package com.comphenix.protocol.reflect.instances;

/**
 * Invoked when a instance provider indicates that a given type cannot or should not be
 * constructed under any circumstances.
 * 
 * @author Kristian
 */
public class NotConstructableException extends IllegalArgumentException {
	/**
	 * Generated by Eclipse.
	 */
	private static final long serialVersionUID = -1144171604744845463L;

	/**
	 * Construct a new not constructable exception.
	 */
	public NotConstructableException() {
		super("This object should never be constructed.");
	}
	
	/**
	 * Construct a new not constructable exception with a custom message.
	 * @param message - detail message
	 */
	public NotConstructableException(String message) {
		super(message);
	}
	
	/**
	 * Construct a new not constructable exception with a custom message and cause.
	 * @param message - detail message
	 * @param cause - cause
	 */
	public NotConstructableException(String message, Throwable cause) {
		super(message, cause);
	}
	
	/**
	 * Construct a new not constructable exception with a custom cause.
	 * @param cause - cause
	 */
	public NotConstructableException(Throwable cause) {
		super( cause);
	}
}
