/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.server;

import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.injector.server.QueuedSendPacket;
import com.comphenix.protocol.injector.server.SocketInjector;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;

public class BukkitSocketInjector
implements SocketInjector {
    private Player player;
    private List<QueuedSendPacket> syncronizedQueue = Collections.synchronizedList(new ArrayList());

    public BukkitSocketInjector(Player player) {
        if (player == null) {
            throw new IllegalArgumentException("Player cannot be NULL.");
        }
        this.player = player;
    }

    @Override
    public Socket getSocket() throws IllegalAccessException {
        throw new UnsupportedOperationException("Cannot get socket from Bukkit player.");
    }

    @Override
    public SocketAddress getAddress() throws IllegalAccessException {
        return this.player.getAddress();
    }

    @Override
    public void disconnect(String message) throws InvocationTargetException {
        this.player.kickPlayer(message);
    }

    @Override
    public void sendServerPacket(Object packet, NetworkMarker marker, boolean filtered) throws InvocationTargetException {
        QueuedSendPacket command = new QueuedSendPacket(packet, marker, filtered);
        this.syncronizedQueue.add(command);
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public Player getUpdatedPlayer() {
        return this.player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferState(SocketInjector delegate) {
        try {
            List<QueuedSendPacket> list = this.syncronizedQueue;
            synchronized (list) {
                for (QueuedSendPacket command : this.syncronizedQueue) {
                    delegate.sendServerPacket(command.getPacket(), command.getMarker(), command.isFiltered());
                }
                this.syncronizedQueue.clear();
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to transmit packets to " + delegate + " from old injector.", e);
        }
    }

    @Override
    public void setUpdatedPlayer(Player updatedPlayer) {
        this.player = updatedPlayer;
    }

    @Override
    public boolean isConnected() {
        return this.player.isOnline();
    }
}

