/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.cloning;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.cloning.Cloner;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AdventureComponentConverter;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.ChunkPosition;
import com.comphenix.protocol.wrappers.ClonableWrapper;
import com.comphenix.protocol.wrappers.ComponentConverter;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedDataWatcher;
import com.comphenix.protocol.wrappers.WrappedServerPing;
import com.comphenix.protocol.wrappers.WrappedVillagerData;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.md_5.bungee.api.chat.BaseComponent;

public class BukkitCloner
implements Cloner {
    private static final Map<Class<?>, Function<Object, Object>> CLONERS = Maps.newConcurrentMap();
    private static Constructor<?> nonNullList;

    private static void fromWrapper(Supplier<Class<?>> getClass, Function<Object, ClonableWrapper> fromHandle) {
        try {
            Class<?> nmsClass = getClass.get();
            if (nmsClass != null) {
                CLONERS.put(nmsClass, nmsObject -> ((ClonableWrapper)fromHandle.apply(nmsObject)).deepClone().getHandle());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void fromConverter(Supplier<Class<?>> getClass, EquivalentConverter converter) {
        try {
            Class<?> nmsClass = getClass.get();
            if (nmsClass != null) {
                CLONERS.put(nmsClass, nmsObject -> converter.getGeneric(converter.getSpecific(nmsObject)));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void fromManual(Supplier<Class<?>> getClass, Function<Object, Object> cloner) {
        try {
            Class<?> nmsClass = getClass.get();
            if (nmsClass != null) {
                CLONERS.put(nmsClass, cloner);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Function<Object, Object> findCloner(Class<?> type) {
        for (Map.Entry<Class<?>, Function<Object, Object>> entry : CLONERS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(type)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public boolean canClone(Object source) {
        if (source == null) {
            return false;
        }
        return this.findCloner(source.getClass()) != null;
    }

    @Override
    public Object clone(Object source) {
        if (source == null) {
            throw new IllegalArgumentException("source cannot be NULL.");
        }
        return this.findCloner(source.getClass()).apply(source);
    }

    private static Cloner nonNullListCloner() {
        return new Cloner(){

            @Override
            public boolean canClone(Object source) {
                return MinecraftReflection.is(MinecraftReflection.getNonNullListClass(), source);
            }

            @Override
            public Object clone(Object source) {
                StructureModifier modifier = new StructureModifier(source.getClass(), true).withTarget(source);
                List list = (List)modifier.read(0);
                Object empty = modifier.read(1);
                if (nonNullList == null) {
                    try {
                        nonNullList = source.getClass().getDeclaredConstructor(List.class, Object.class);
                        nonNullList.setAccessible(true);
                    }
                    catch (ReflectiveOperationException ex) {
                        throw new RuntimeException("Could not find NonNullList constructor", ex);
                    }
                }
                try {
                    return nonNullList.newInstance(new ArrayList(list), empty);
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException("Could not create new NonNullList", ex);
                }
            }
        };
    }

    static {
        BukkitCloner.fromManual(MinecraftReflection::getItemStackClass, source -> MinecraftReflection.getMinecraftItemStack(MinecraftReflection.getBukkitItemStack(source).clone()));
        BukkitCloner.fromWrapper(MinecraftReflection::getDataWatcherClass, WrappedDataWatcher::new);
        BukkitCloner.fromConverter(MinecraftReflection::getBlockPositionClass, BlockPosition.getConverter());
        BukkitCloner.fromConverter(MinecraftReflection::getChunkPositionClass, ChunkPosition.getConverter());
        BukkitCloner.fromWrapper(MinecraftReflection::getServerPingClass, WrappedServerPing::fromHandle);
        BukkitCloner.fromConverter(MinecraftReflection::getMinecraftKeyClass, MinecraftKey.getConverter());
        BukkitCloner.fromWrapper(MinecraftReflection::getIBlockDataClass, WrappedBlockData::fromHandle);
        BukkitCloner.fromManual(MinecraftReflection::getNonNullListClass, source -> BukkitCloner.nonNullListCloner().clone(source));
        BukkitCloner.fromWrapper(MinecraftReflection::getNBTBaseClass, NbtFactory::fromNMS);
        BukkitCloner.fromWrapper(MinecraftReflection::getIChatBaseComponentClass, WrappedChatComponent::fromHandle);
        BukkitCloner.fromWrapper(WrappedVillagerData::getNmsClass, WrappedVillagerData::fromHandle);
        BukkitCloner.fromConverter(MinecraftReflection::getSectionPositionClass, BukkitConverters.getSectionPositionConverter());
        try {
            BukkitCloner.fromManual(ComponentConverter::getBaseComponentArrayClass, source -> ComponentConverter.clone((BaseComponent[])source));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            BukkitCloner.fromManual(AdventureComponentConverter::getComponentClass, source -> AdventureComponentConverter.clone(source));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        nonNullList = null;
    }
}

