/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.fuzzy;

import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.ClassExactMatcher;
import com.google.common.base.Objects;
import java.util.Set;

class ClassSetMatcher
extends AbstractFuzzyMatcher<Class<?>> {
    private final Set<Class<?>> classes;

    public ClassSetMatcher(Set<Class<?>> classes) {
        if (classes == null) {
            throw new IllegalArgumentException("Set of classes cannot be NULL.");
        }
        this.classes = classes;
    }

    @Override
    public boolean isMatch(Class<?> value, Object parent) {
        return this.classes.contains(value);
    }

    @Override
    protected int calculateRoundNumber() {
        int roundNumber = 0;
        for (Class<?> clazz : this.classes) {
            roundNumber = this.combineRounds(roundNumber, -ClassExactMatcher.getClassNumber(clazz));
        }
        return roundNumber;
    }

    public String toString() {
        return "match any: " + this.classes;
    }

    public int hashCode() {
        return this.classes.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClassSetMatcher) {
            return Objects.equal(this.classes, ((ClassSetMatcher)obj).classes);
        }
        return true;
    }
}

