/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.EquivalentConverter;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.google.common.base.Objects;
import java.lang.reflect.Constructor;
import org.bukkit.util.Vector;

public class ChunkPosition {
    public static ChunkPosition ORIGIN = new ChunkPosition(0, 0, 0);
    private static Constructor<?> chunkPositionConstructor;
    protected final int x;
    protected final int y;
    protected final int z;
    private static StructureModifier<Integer> intModifier;

    public ChunkPosition(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public ChunkPosition(Vector vector) {
        if (vector == null) {
            throw new IllegalArgumentException("Vector cannot be NULL.");
        }
        this.x = vector.getBlockX();
        this.y = vector.getBlockY();
        this.z = vector.getBlockZ();
    }

    public Vector toVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public ChunkPosition add(ChunkPosition other) {
        if (other == null) {
            throw new IllegalArgumentException("other cannot be NULL");
        }
        return new ChunkPosition(this.x + other.x, this.y + other.y, this.z + other.z);
    }

    public ChunkPosition subtract(ChunkPosition other) {
        if (other == null) {
            throw new IllegalArgumentException("other cannot be NULL");
        }
        return new ChunkPosition(this.x - other.x, this.y - other.y, this.z - other.z);
    }

    public ChunkPosition multiply(int factor) {
        return new ChunkPosition(this.x * factor, this.y * factor, this.z * factor);
    }

    public ChunkPosition divide(int divisor) {
        if (divisor == 0) {
            throw new IllegalArgumentException("Cannot divide by null.");
        }
        return new ChunkPosition(this.x / divisor, this.y / divisor, this.z / divisor);
    }

    public static EquivalentConverter<ChunkPosition> getConverter() {
        return new EquivalentConverter<ChunkPosition>(){

            @Override
            public Object getGeneric(ChunkPosition specific) {
                if (chunkPositionConstructor == null) {
                    try {
                        chunkPositionConstructor = MinecraftReflection.getChunkPositionClass().getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot find chunk position constructor.", e);
                    }
                }
                try {
                    Object result = chunkPositionConstructor.newInstance(specific.x, specific.y, specific.z);
                    return result;
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot construct ChunkPosition.", e);
                }
            }

            @Override
            public ChunkPosition getSpecific(Object generic) {
                if (MinecraftReflection.isChunkPosition(generic)) {
                    intModifier = new StructureModifier(generic.getClass(), null, false).withType(Integer.TYPE);
                    if (intModifier.size() < 3) {
                        throw new IllegalStateException("Cannot read class " + generic.getClass() + " for its integer fields.");
                    }
                    if (intModifier.size() >= 3) {
                        try {
                            StructureModifier instance = intModifier.withTarget(generic);
                            ChunkPosition result = new ChunkPosition((Integer)instance.read(0), (Integer)instance.read(1), (Integer)instance.read(2));
                            return result;
                        }
                        catch (FieldAccessException e) {
                            throw new RuntimeException("Field access error.", e);
                        }
                    }
                }
                return null;
            }

            @Override
            public Class<ChunkPosition> getSpecificType() {
                return ChunkPosition.class;
            }
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ChunkPosition) {
            ChunkPosition other = (ChunkPosition)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.x, this.y, this.z});
    }

    public String toString() {
        return "WrappedChunkPosition [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }
}

