/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.ClonableWrapper;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.Vector3F;
import com.comphenix.protocol.wrappers.WrappedChunkCoordinate;
import com.comphenix.protocol.wrappers.WrappedWatchableObject;
import com.comphenix.protocol.wrappers.collection.ConvertedMap;
import com.google.common.collect.ImmutableBiMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class WrappedDataWatcher
extends AbstractWrapper
implements Iterable<WrappedWatchableObject>,
ClonableWrapper {
    private static final Class<?> HANDLE_TYPE = MinecraftReflection.getDataWatcherClass();
    private static MethodAccessor GETTER = null;
    private static MethodAccessor SETTER = null;
    private static MethodAccessor REGISTER = null;
    private static FieldAccessor ENTITY_DATA_FIELD = null;
    private static FieldAccessor ENTITY_FIELD = null;
    private static FieldAccessor MAP_FIELD = null;
    private static ConstructorAccessor constructor = null;
    private static ConstructorAccessor eggConstructor = null;
    private static Object fakeEntity = null;
    private static final ImmutableBiMap<Class<?>, Integer> CLASS_TO_ID = new ImmutableBiMap.Builder().put(Byte.class, (Object)0).put(Short.class, (Object)1).put(Integer.class, (Object)2).put(Float.class, (Object)3).put(String.class, (Object)4).put(MinecraftReflection.getItemStackClass(), (Object)5).put(MinecraftReflection.getBlockPositionClass(), (Object)6).put(Vector3F.getMinecraftClass(), (Object)7).build();

    public WrappedDataWatcher(Object handle) {
        super(HANDLE_TYPE);
        this.setHandle(handle);
    }

    public WrappedDataWatcher() {
        this(WrappedDataWatcher.newHandle(WrappedDataWatcher.fakeEntity()));
    }

    public WrappedDataWatcher(Entity entity) {
        this(WrappedDataWatcher.newHandle(BukkitUnwrapper.getInstance().unwrapItem(entity)));
    }

    public WrappedDataWatcher(List<WrappedWatchableObject> objects) {
        this();
        if (MinecraftReflection.watcherObjectExists()) {
            for (WrappedWatchableObject object : objects) {
                this.setObject(object.getWatcherObject(), object);
            }
        } else {
            for (WrappedWatchableObject object : objects) {
                this.setObject(object.getIndex(), object);
            }
        }
    }

    private static Object newHandle(Object entity) {
        if (constructor == null) {
            constructor = Accessors.getConstructorAccessor(HANDLE_TYPE, MinecraftReflection.getEntityClass());
        }
        return constructor.invoke(entity);
    }

    private static Object fakeEntity() {
        if (fakeEntity != null) {
            return fakeEntity;
        }
        if (eggConstructor == null) {
            eggConstructor = Accessors.getConstructorAccessor(MinecraftReflection.getMinecraftClass("EntityEgg"), MinecraftReflection.getNmsWorldClass(), Double.TYPE, Double.TYPE, Double.TYPE);
        }
        Object world = BukkitUnwrapper.getInstance().unwrapItem(Bukkit.getWorlds().get(0));
        fakeEntity = eggConstructor.invoke(world, 0, 0, 0);
        return fakeEntity;
    }

    private Map<Integer, Object> getMap() {
        if (MAP_FIELD == null) {
            try {
                FuzzyReflection fuzzy = FuzzyReflection.fromClass(this.handleType, true);
                MAP_FIELD = Accessors.getFieldAccessor(fuzzy.getField(FuzzyFieldContract.newBuilder().banModifier(8).typeDerivedOf(Map.class).build()));
            }
            catch (IllegalArgumentException ex) {
                throw new FieldAccessException("Failed to find watchable object map");
            }
        }
        return (Map)MAP_FIELD.get(this.handle);
    }

    public Map<Integer, WrappedWatchableObject> asMap() {
        return new ConvertedMap<Integer, Object, WrappedWatchableObject>(this.getMap()){

            @Override
            protected WrappedWatchableObject toOuter(Object inner) {
                return inner != null ? new WrappedWatchableObject(inner) : null;
            }

            @Override
            protected Object toInner(WrappedWatchableObject outer) {
                return outer != null ? outer.getHandle() : null;
            }
        };
    }

    public Set<Integer> getIndexes() {
        return this.getMap().keySet();
    }

    public List<WrappedWatchableObject> getWatchableObjects() {
        return new ArrayList<WrappedWatchableObject>(this.asMap().values());
    }

    @Override
    public Iterator<WrappedWatchableObject> iterator() {
        return this.getWatchableObjects().iterator();
    }

    public int size() {
        return this.getMap().size();
    }

    public WrappedWatchableObject getWatchableObject(int index) {
        Object handle = this.getMap().get(index);
        if (handle != null) {
            return new WrappedWatchableObject(handle);
        }
        return null;
    }

    @Deprecated
    public WrappedWatchableObject removeObject(int index) {
        return this.remove(index);
    }

    public WrappedWatchableObject remove(int index) {
        Object removed = this.getMap().remove(index);
        return removed != null ? new WrappedWatchableObject(removed) : null;
    }

    public boolean hasIndex(int index) {
        return this.getMap().containsKey(index);
    }

    public Set<Integer> indexSet() {
        return this.getMap().keySet();
    }

    public void clear() {
        this.getMap().clear();
    }

    public Byte getByte(int index) {
        return (Byte)this.getObject(index);
    }

    public Short getShort(int index) {
        return (Short)this.getObject(index);
    }

    public Integer getInteger(int index) {
        return (Integer)this.getObject(index);
    }

    public Float getFloat(int index) {
        return (Float)this.getObject(index);
    }

    public String getString(int index) {
        return (String)this.getObject(index);
    }

    public ItemStack getItemStack(int index) {
        return (ItemStack)this.getObject(index);
    }

    public WrappedChunkCoordinate getChunkCoordinate(int index) {
        return (WrappedChunkCoordinate)this.getObject(index);
    }

    public Object getObject(int index) {
        return this.getObject(WrappedDataWatcherObject.fromIndex(index));
    }

    public Object getObject(WrappedDataWatcherObject object) {
        Validate.notNull((Object)object, (String)"Watcher object cannot be null!");
        if (GETTER == null) {
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(this.handleType, true);
            GETTER = MinecraftReflection.watcherObjectExists() ? Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterExactType(object.getHandleType()).returnTypeExact(Object.class).build(), "get")) : Accessors.getMethodAccessor(fuzzy.getMethod(FuzzyMethodContract.newBuilder().parameterExactType(Integer.TYPE).returnTypeExact(MinecraftReflection.getDataWatcherItemClass()).build()));
        }
        try {
            Object value = GETTER.invoke(this.handle, object.getHandle());
            return WrappedWatchableObject.getWrapped(value);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void setObject(int index, Object value, boolean update) {
        if (MinecraftReflection.watcherObjectExists() && !this.hasIndex(index)) {
            throw new IllegalArgumentException("You cannot register objects without a watcher object!");
        }
        this.setObject(WrappedDataWatcherObject.fromIndex(index), value, update);
    }

    public void setObject(int index, Object value) {
        this.setObject(index, value, false);
    }

    public void setObject(int index, Serializer serializer, Object value, boolean update) {
        this.setObject(new WrappedDataWatcherObject(index, serializer), value, update);
    }

    public void setObject(int index, Serializer serializer, Object value) {
        this.setObject(new WrappedDataWatcherObject(index, serializer), value, false);
    }

    public void setObject(int index, WrappedWatchableObject value, boolean update) {
        this.setObject(index, value.getRawValue(), update);
    }

    public void setObject(int index, WrappedWatchableObject value) {
        this.setObject(index, value.getRawValue(), false);
    }

    public void setObject(WrappedDataWatcherObject object, WrappedWatchableObject value, boolean update) {
        this.setObject(object, value.getRawValue(), update);
    }

    public void setObject(WrappedDataWatcherObject object, WrappedWatchableObject value) {
        this.setObject(object, value.getRawValue(), false);
    }

    public void setObject(WrappedDataWatcherObject object, Object value, boolean update) {
        Validate.notNull((Object)object, (String)"Watcher object cannot be null!");
        if (SETTER == null && REGISTER == null) {
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(this.handleType, true);
            FuzzyMethodContract contract = FuzzyMethodContract.newBuilder().banModifier(8).requireModifier(1).parameterExactArray(object.getHandleType(), Object.class).build();
            List<Method> methods = fuzzy.getMethodList(contract);
            for (Method method : methods) {
                if (method.getName().equals("set") || method.getName().equals("watch")) {
                    SETTER = Accessors.getMethodAccessor(method);
                    continue;
                }
                REGISTER = Accessors.getMethodAccessor(method);
            }
        }
        value = WrappedWatchableObject.getUnwrapped(value);
        if (this.hasIndex(object.getIndex())) {
            SETTER.invoke(this.handle, object.getHandle(), value);
        } else {
            object.checkSerializer();
            REGISTER.invoke(this.handle, object.getHandle(), value);
        }
        if (update) {
            this.getWatchableObject(object.getIndex()).setDirtyState(update);
        }
    }

    public void setObject(WrappedDataWatcherObject object, Object value) {
        this.setObject(object, value, false);
    }

    @Override
    public WrappedDataWatcher deepClone() {
        WrappedDataWatcher clone = new WrappedDataWatcher(this.getEntity());
        if (MinecraftReflection.watcherObjectExists()) {
            for (WrappedWatchableObject wrapper : this) {
                clone.setObject(wrapper.getWatcherObject(), wrapper);
            }
        } else {
            for (WrappedWatchableObject wrapper : this) {
                clone.setObject(wrapper.getIndex(), wrapper);
            }
        }
        return clone;
    }

    public static WrappedDataWatcher getEntityWatcher(Entity entity) {
        BukkitUnwrapper unwrapper;
        Object handle;
        if (ENTITY_DATA_FIELD == null) {
            ENTITY_DATA_FIELD = Accessors.getFieldAccessor(MinecraftReflection.getEntityClass(), MinecraftReflection.getDataWatcherClass(), true);
        }
        return (handle = ENTITY_DATA_FIELD.get((unwrapper = new BukkitUnwrapper()).unwrapItem(entity))) != null ? new WrappedDataWatcher(handle) : null;
    }

    public Entity getEntity() {
        Object entity;
        if (ENTITY_FIELD == null) {
            ENTITY_FIELD = Accessors.getFieldAccessor(HANDLE_TYPE, MinecraftReflection.getEntityClass(), true);
        }
        if ((entity = ENTITY_FIELD.get(this.handle)) == null) {
            throw new NullPointerException(this.handle + "." + ENTITY_FIELD);
        }
        return (Entity)MinecraftReflection.getBukkitEntity(entity);
    }

    public void setEntity(Entity entity) {
        if (ENTITY_FIELD == null) {
            ENTITY_FIELD = Accessors.getFieldAccessor(HANDLE_TYPE, MinecraftReflection.getEntityClass(), true);
        }
        ENTITY_FIELD.set(this.handle, BukkitUnwrapper.getInstance().unwrapItem(entity));
    }

    public static Integer getTypeID(Class<?> clazz) {
        return (Integer)CLASS_TO_ID.get(clazz);
    }

    public static Class<?> getTypeClass(int typeID) {
        return (Class)CLASS_TO_ID.inverse().get((Object)typeID);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof WrappedDataWatcher) {
            WrappedDataWatcher other = (WrappedDataWatcher)obj;
            Iterator<WrappedWatchableObject> first = this.iterator();
            Iterator<WrappedWatchableObject> second = other.iterator();
            if (this.size() != other.size()) {
                return false;
            }
            while (first.hasNext() && second.hasNext()) {
                if (first.next().equals(second.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.getWatchableObjects().hashCode();
    }

    @Override
    public String toString() {
        return "WrappedDataWatcher[handle=" + this.handle + "]";
    }

    public static class Registry {
        private static boolean INITIALIZED = false;
        private static List<Serializer> REGISTRY = new ArrayList<Serializer>();

        public static Serializer get(Class<?> clazz) {
            Validate.notNull(clazz, (String)"Class cannot be null!");
            Registry.initialize();
            for (Serializer serializer : REGISTRY) {
                if (!serializer.getType().equals(clazz)) continue;
                return serializer;
            }
            throw new IllegalArgumentException("No serializer found for " + clazz);
        }

        public static Serializer get(Class<?> clazz, boolean optional) {
            Validate.notNull(clazz, (String)"Class cannot be null!");
            Registry.initialize();
            Validate.notEmpty(REGISTRY, (String)"Registry has no elements!");
            for (Serializer serializer : REGISTRY) {
                if (!serializer.getType().equals(clazz) || serializer.isOptional() != optional) continue;
                return serializer;
            }
            throw new IllegalArgumentException("No serializer found for " + (optional ? "Optional<" + clazz + ">" : clazz));
        }

        public static Serializer fromHandle(Object handle) {
            Validate.notNull((Object)handle, (String)"handle cannot be null!");
            Registry.initialize();
            for (Serializer serializer : REGISTRY) {
                if (!serializer.getHandle().equals(handle)) continue;
                return serializer;
            }
            return null;
        }

        private static void initialize() {
            if (INITIALIZED) {
                return;
            }
            INITIALIZED = true;
            List<Field> candidates = FuzzyReflection.fromClass(MinecraftReflection.getDataWatcherRegistryClass(), true).getFieldListByType(MinecraftReflection.getDataWatcherSerializerClass());
            for (Field candidate : candidates) {
                Object serializer;
                Class innerClass;
                Type generic = candidate.getGenericType();
                if (!(generic instanceof ParameterizedType)) continue;
                ParameterizedType type = (ParameterizedType)generic;
                Type[] args = type.getActualTypeArguments();
                Type arg = args[0];
                boolean optional = false;
                if (arg instanceof Class) {
                    innerClass = (Class)arg;
                } else if (arg instanceof ParameterizedType) {
                    innerClass = (Class)((ParameterizedType)arg).getActualTypeArguments()[0];
                    optional = true;
                } else {
                    throw new IllegalStateException("Failed to find inner class of field " + candidate);
                }
                try {
                    serializer = candidate.get(null);
                }
                catch (ReflectiveOperationException e) {
                    throw new IllegalStateException("Failed to read field " + candidate);
                }
                if (serializer == null) {
                    throw new RuntimeException("Failed to read serializer: " + candidate.getName());
                }
                REGISTRY.add(new Serializer(innerClass, serializer, optional));
            }
        }

        public static Serializer getChatComponentSerializer() {
            return Registry.getChatComponentSerializer(false);
        }

        public static Serializer getChatComponentSerializer(boolean optional) {
            return Registry.get(MinecraftReflection.getIChatBaseComponentClass(), optional);
        }

        public static Serializer getItemStackSerializer(boolean optional) {
            return Registry.get(MinecraftReflection.getItemStackClass(), optional);
        }

        public static Serializer getBlockDataSerializer(boolean optional) {
            return Registry.get(MinecraftReflection.getIBlockDataClass(), optional);
        }

        public static Serializer getVectorSerializer() {
            return Registry.get(Vector3F.getMinecraftClass());
        }

        public static Serializer getBlockPositionSerializer(boolean optional) {
            return Registry.get(MinecraftReflection.getBlockPositionClass(), optional);
        }

        public static Serializer getDirectionSerializer() {
            return Registry.get(EnumWrappers.getDirectionClass());
        }

        public static Serializer getUUIDSerializer(boolean optional) {
            return Registry.get(UUID.class, optional);
        }

        public static Serializer getNBTCompoundSerializer() {
            return Registry.get(MinecraftReflection.getNBTCompoundClass(), false);
        }
    }

    public static class Serializer
    extends AbstractWrapper {
        private static final Class<?> HANDLE_TYPE = MinecraftReflection.getDataWatcherSerializerClass();
        private final Class<?> type;
        private final boolean optional;

        public Serializer(Class<?> type, Object handle, boolean optional) {
            super(HANDLE_TYPE);
            this.type = type;
            this.optional = optional;
            this.setHandle(handle);
        }

        public Class<?> getType() {
            return this.type;
        }

        public boolean isOptional() {
            return this.optional;
        }

        @Override
        public String toString() {
            return "Serializer[type=" + this.type + ", handle=" + this.handle + ", optional=" + this.optional + "]";
        }
    }

    private static class DummyWatcherObject
    extends WrappedDataWatcherObject {
        private final int index;

        public DummyWatcherObject(int index) {
            this.index = index;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Serializer getSerializer() {
            return null;
        }

        @Override
        public Object getHandle() {
            return this.getIndex();
        }

        @Override
        public Class<?> getHandleType() {
            return Integer.TYPE;
        }

        @Override
        public void checkSerializer() {
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof DummyWatcherObject) {
                DummyWatcherObject that = (DummyWatcherObject)obj;
                return this.index == that.index;
            }
            return false;
        }
    }

    public static class WrappedDataWatcherObject {
        private static final Class<?> HANDLE_TYPE = MinecraftReflection.getDataWatcherObjectClass();
        private static ConstructorAccessor constructor = null;
        private static MethodAccessor getSerializer = null;
        private StructureModifier<Object> modifier;
        private Object handle;

        protected WrappedDataWatcherObject() {
        }

        public WrappedDataWatcherObject(Object handle) {
            this.handle = handle;
            this.modifier = new StructureModifier(HANDLE_TYPE).withTarget(handle);
        }

        public WrappedDataWatcherObject(int index, Serializer serializer) {
            this(WrappedDataWatcherObject.newHandle(index, serializer));
        }

        static WrappedDataWatcherObject fromIndex(int index) {
            if (MinecraftReflection.watcherObjectExists()) {
                return new WrappedDataWatcherObject(WrappedDataWatcherObject.newHandle(index));
            }
            return new DummyWatcherObject(index);
        }

        private static Object newHandle(int index) {
            Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"index cannot be negative!");
            if (constructor == null) {
                constructor = Accessors.getConstructorAccessor(HANDLE_TYPE.getConstructors()[0]);
            }
            return constructor.invoke(index, null);
        }

        private static Object newHandle(int index, Serializer serializer) {
            Validate.isTrue((index >= 0 ? 1 : 0) != 0, (String)"index cannot be negative!");
            Validate.notNull((Object)serializer, (String)"serializer cannot be null!");
            if (constructor == null) {
                constructor = Accessors.getConstructorAccessor(HANDLE_TYPE.getConstructors()[0]);
            }
            Object handle = serializer.getHandle();
            return constructor.invoke(index, handle);
        }

        public int getIndex() {
            return (Integer)this.modifier.read(0);
        }

        public Serializer getSerializer() {
            Object serializer;
            if (getSerializer == null) {
                getSerializer = Accessors.getMethodAccessor(FuzzyReflection.fromClass(HANDLE_TYPE, true).getMethodByParameters("getSerializer", MinecraftReflection.getDataWatcherSerializerClass(), (Class<?>[])new Class[0]));
            }
            if ((serializer = getSerializer.invoke(this.handle, new Object[0])) != null) {
                Serializer wrapper = Registry.fromHandle(serializer);
                if (wrapper != null) {
                    return wrapper;
                }
                return new Serializer(null, serializer, false);
            }
            return null;
        }

        public void checkSerializer() {
            Validate.notNull((Object)this.getSerializer(), (String)"You must specify a serializer to register an object!");
        }

        public Object getHandle() {
            return this.handle;
        }

        public Class<?> getHandleType() {
            return HANDLE_TYPE;
        }

        public String toString() {
            return "DataWatcherObject[index=" + this.getIndex() + ", serializer=" + this.getSerializer() + "]";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof WrappedDataWatcherObject) {
                WrappedDataWatcherObject other = (WrappedDataWatcherObject)obj;
                return this.handle.equals(other.handle);
            }
            return false;
        }

        public int hashCode() {
            return this.handle.hashCode();
        }
    }
}

