/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import org.bukkit.Color;
import org.bukkit.Particle;

public class WrappedParticle<T> {
    private static MethodAccessor toBukkit;
    private static MethodAccessor toNMS;
    private static MethodAccessor toCraftData;
    private final Particle particle;
    private final T data;
    private final Object handle;

    private static void ensureMethods() {
        if (toBukkit != null && toNMS != null) {
            return;
        }
        FuzzyReflection fuzzy = FuzzyReflection.fromClass(MinecraftReflection.getCraftBukkitClass("CraftParticle"));
        FuzzyMethodContract contract = FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(Particle.class).parameterExactType(MinecraftReflection.getMinecraftClass("ParticleParam")).build();
        toBukkit = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
        contract = FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(MinecraftReflection.getMinecraftClass("ParticleParam")).parameterCount(2).build();
        toNMS = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
        Class<?> cbData = MinecraftReflection.getCraftBukkitClass("block.data.CraftBlockData");
        fuzzy = FuzzyReflection.fromClass(cbData);
        contract = FuzzyMethodContract.newBuilder().requireModifier(8).returnTypeExact(cbData).parameterExactArray(MinecraftReflection.getIBlockDataClass()).build();
        toCraftData = Accessors.getMethodAccessor(fuzzy.getMethod(contract));
    }

    private WrappedParticle(Object handle, Particle particle, T data) {
        this.handle = handle;
        this.particle = particle;
        this.data = data;
    }

    public Particle getParticle() {
        return this.particle;
    }

    public T getData() {
        return this.data;
    }

    public Object getHandle() {
        return this.handle;
    }

    public static WrappedParticle fromHandle(Object handle) {
        WrappedParticle.ensureMethods();
        Particle bukkit = (Particle)toBukkit.invoke(null, handle);
        Object data = null;
        switch (bukkit) {
            case BLOCK_CRACK: 
            case BLOCK_DUST: 
            case FALLING_DUST: {
                data = WrappedParticle.getBlockData(handle);
                break;
            }
            case ITEM_CRACK: {
                data = WrappedParticle.getItem(handle);
                break;
            }
            case REDSTONE: {
                data = WrappedParticle.getRedstone(handle);
                break;
            }
        }
        return new WrappedParticle<Object>(handle, bukkit, data);
    }

    private static WrappedBlockData getBlockData(Object handle) {
        return new StructureModifier(handle.getClass()).withTarget(handle).withType(MinecraftReflection.getIBlockDataClass(), BukkitConverters.getWrappedBlockDataConverter()).read(0);
    }

    private static Object getItem(Object handle) {
        return new StructureModifier(handle.getClass()).withTarget(handle).withType(MinecraftReflection.getItemStackClass(), BukkitConverters.getItemStackConverter()).read(0);
    }

    private static Object getRedstone(Object handle) {
        StructureModifier modifier = new StructureModifier(handle.getClass()).withTarget(handle).withType(Float.TYPE);
        return new Particle.DustOptions(Color.fromRGB((int)((int)(((Float)modifier.read(0)).floatValue() * 255.0f)), (int)((int)(((Float)modifier.read(1)).floatValue() * 255.0f)), (int)((int)(((Float)modifier.read(2)).floatValue() * 255.0f))), ((Float)modifier.read(3)).floatValue());
    }

    public static <T> WrappedParticle<T> create(Particle particle, T data) {
        WrappedParticle.ensureMethods();
        Object bukkitData = data;
        if (data instanceof WrappedBlockData) {
            WrappedBlockData blockData = (WrappedBlockData)data;
            bukkitData = toCraftData.invoke(null, blockData.getHandle());
        }
        Object handle = toNMS.invoke(null, particle, bukkitData);
        return new WrappedParticle<T>(handle, particle, data);
    }
}

