/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.events;

import com.comphenix.protocol.PacketType;

public enum ConnectionSide {
    SERVER_SIDE,
    CLIENT_SIDE,
    BOTH;


    public boolean isForClient() {
        return this == CLIENT_SIDE || this == BOTH;
    }

    public boolean isForServer() {
        return this == SERVER_SIDE || this == BOTH;
    }

    public PacketType.Sender getSender() {
        if (this == SERVER_SIDE) {
            return PacketType.Sender.SERVER;
        }
        if (this == CLIENT_SIDE) {
            return PacketType.Sender.CLIENT;
        }
        return null;
    }

    public static ConnectionSide add(ConnectionSide a, ConnectionSide b) {
        boolean server;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        boolean client = a.isForClient() || b.isForClient();
        boolean bl = server = a.isForServer() || b.isForServer();
        if (client && server) {
            return BOTH;
        }
        if (client) {
            return CLIENT_SIDE;
        }
        return SERVER_SIDE;
    }
}

