/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.error.RethrowErrorReporter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.reflect.FieldAccessException;
import com.comphenix.protocol.wrappers.BukkitConverters;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class PacketConstructor {
    public static PacketConstructor DEFAULT = new PacketConstructor(null);
    private Constructor<?> constructorMethod;
    private PacketType type;
    private List<Unwrapper> unwrappers;
    private Unwrapper[] paramUnwrapper;

    private PacketConstructor(Constructor<?> constructorMethod) {
        this.constructorMethod = constructorMethod;
        this.unwrappers = Lists.newArrayList((Object[])new Unwrapper[]{new BukkitUnwrapper(new RethrowErrorReporter())});
        this.unwrappers.addAll(BukkitConverters.getUnwrappers());
    }

    private PacketConstructor(PacketType type, Constructor<?> constructorMethod, List<Unwrapper> unwrappers, Unwrapper[] paramUnwrapper) {
        this.type = type;
        this.constructorMethod = constructorMethod;
        this.unwrappers = unwrappers;
        this.paramUnwrapper = paramUnwrapper;
    }

    public ImmutableList<Unwrapper> getUnwrappers() {
        return ImmutableList.copyOf(this.unwrappers);
    }

    @Deprecated
    public int getPacketID() {
        return this.type.getCurrentId();
    }

    public PacketType getType() {
        return this.type;
    }

    public PacketConstructor withUnwrappers(List<Unwrapper> unwrappers) {
        return new PacketConstructor(this.type, this.constructorMethod, unwrappers, this.paramUnwrapper);
    }

    public PacketConstructor withPacket(PacketType type, Object[] values) {
        Class[] types = new Class[values.length];
        Throwable lastException = null;
        Unwrapper[] paramUnwrapper = new Unwrapper[values.length];
        block4: for (int i = 0; i < types.length; ++i) {
            if (values[i] != null) {
                types[i] = PacketConstructor.getClass(values[i]);
                for (Unwrapper unwrapper : this.unwrappers) {
                    Object result = null;
                    try {
                        result = unwrapper.unwrapItem(values[i]);
                    }
                    catch (OutOfMemoryError e) {
                        throw e;
                    }
                    catch (ThreadDeath e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        lastException = e;
                    }
                    if (result == null) continue;
                    types[i] = PacketConstructor.getClass(result);
                    paramUnwrapper[i] = unwrapper;
                    continue block4;
                }
                continue;
            }
            types[i] = Object.class;
        }
        Class<?> packetClass = PacketRegistry.getPacketClassFromType(type);
        for (Constructor<?> constructor : packetClass.getConstructors()) {
            Class<?>[] params = constructor.getParameterTypes();
            if (!PacketConstructor.isCompatible(types, params)) continue;
            return new PacketConstructor(type, constructor, this.unwrappers, paramUnwrapper);
        }
        throw new IllegalArgumentException("No suitable constructor could be found.", lastException);
    }

    public PacketContainer createPacket(Object ... values) throws FieldAccessException {
        try {
            for (int i = 0; i < values.length; ++i) {
                if (this.paramUnwrapper[i] == null) continue;
                values[i] = this.paramUnwrapper[i].unwrapItem(values[i]);
            }
            Object nmsPacket = this.constructorMethod.newInstance(values);
            return new PacketContainer(this.type, nmsPacket);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InstantiationException e) {
            throw new FieldAccessException("Cannot construct an abstract packet.", e);
        }
        catch (IllegalAccessException e) {
            throw new FieldAccessException("Cannot construct packet due to a security limitation.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Minecraft error.", e);
        }
    }

    private static boolean isCompatible(Class<?>[] types, Class<?>[] params) {
        if (params.length == types.length) {
            for (int i = 0; i < params.length; ++i) {
                Class<?> inputType = types[i];
                Class paramType = params[i];
                if (!inputType.isPrimitive() && paramType.isPrimitive()) {
                    paramType = Primitives.wrap(paramType);
                }
                if (paramType.isAssignableFrom(inputType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Class<?> getClass(Object obj) {
        if (obj instanceof Class) {
            return (Class)obj;
        }
        return obj.getClass();
    }

    public static interface Unwrapper {
        public Object unwrapItem(Object var1);
    }
}

