/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.packet;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.injector.packet.MapContainer;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PacketRegistry {
    private static volatile boolean INITIALIZED = false;
    protected static final Class<?> ENUM_PROTOCOL = MinecraftReflection.getEnumProtocolClass();
    protected static volatile Register REGISTER;

    public static synchronized void synchronize() {
        if (REGISTER.isOutdated()) {
            PacketRegistry.initialize();
        }
    }

    protected static synchronized Register createOldRegister() {
        ?[] protocols = ENUM_PROTOCOL.getEnumConstants();
        LinkedHashMap serverMaps = Maps.newLinkedHashMap();
        LinkedHashMap clientMaps = Maps.newLinkedHashMap();
        Register result = new Register();
        StructureModifier modifier = null;
        for (Object protocol : protocols) {
            if (modifier == null) {
                modifier = new StructureModifier(protocol.getClass().getSuperclass(), false);
            }
            StructureModifier maps = modifier.withTarget(protocol).withType(Map.class);
            for (Map.Entry entry : ((Map)maps.read(0)).entrySet()) {
                String direction = entry.getKey().toString();
                if (direction.contains("CLIENTBOUND")) {
                    serverMaps.put(protocol, (Map)entry.getValue());
                    continue;
                }
                if (!direction.contains("SERVERBOUND")) continue;
                clientMaps.put(protocol, (Map)entry.getValue());
            }
        }
        for (Object map : serverMaps.values()) {
            result.addContainer(new MapContainer(map));
        }
        for (Object map : clientMaps.values()) {
            result.addContainer(new MapContainer(map));
        }
        for (Object protocol : protocols) {
            Enum enumProtocol = (Enum)protocol;
            PacketType.Protocol equivalent = PacketType.Protocol.fromVanilla(enumProtocol);
            if (serverMaps.containsKey(protocol)) {
                PacketRegistry.associatePackets(result, (Map)serverMaps.get(protocol), equivalent, PacketType.Sender.SERVER);
            }
            if (!clientMaps.containsKey(protocol)) continue;
            PacketRegistry.associatePackets(result, (Map)clientMaps.get(protocol), equivalent, PacketType.Sender.CLIENT);
        }
        return result;
    }

    private static synchronized Register createNewRegister() {
        ?[] protocols = ENUM_PROTOCOL.getEnumConstants();
        LinkedHashMap serverMaps = Maps.newLinkedHashMap();
        LinkedHashMap clientMaps = Maps.newLinkedHashMap();
        Register result = new Register();
        Field mainMapField = null;
        Field packetMapField = null;
        for (Object protocol : protocols) {
            Map directionMap;
            if (mainMapField == null) {
                FuzzyReflection fuzzy = FuzzyReflection.fromClass(protocol.getClass(), true);
                mainMapField = fuzzy.getField(FuzzyFieldContract.newBuilder().banModifier(8).requireModifier(16).typeDerivedOf(Map.class).build());
                mainMapField.setAccessible(true);
            }
            try {
                directionMap = (Map)mainMapField.get(protocol);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("Failed to access packet map", ex);
            }
            for (Map.Entry entry : directionMap.entrySet()) {
                Map packetMap;
                Object holder = entry.getValue();
                if (packetMapField == null) {
                    FuzzyReflection fuzzy = FuzzyReflection.fromClass(holder.getClass(), true);
                    packetMapField = fuzzy.getField(FuzzyFieldContract.newBuilder().banModifier(8).requireModifier(16).typeDerivedOf(Map.class).build());
                    packetMapField.setAccessible(true);
                }
                try {
                    packetMap = (Map)packetMapField.get(holder);
                }
                catch (ReflectiveOperationException ex) {
                    throw new RuntimeException("Failed to access packet map", ex);
                }
                String direction = entry.getKey().toString();
                if (direction.contains("CLIENTBOUND")) {
                    serverMaps.put(protocol, packetMap);
                    continue;
                }
                if (!direction.contains("SERVERBOUND")) continue;
                clientMaps.put(protocol, packetMap);
            }
        }
        for (Object protocol : protocols) {
            Enum enumProtocol = (Enum)protocol;
            PacketType.Protocol equivalent = PacketType.Protocol.fromVanilla(enumProtocol);
            if (serverMaps.containsKey(protocol)) {
                PacketRegistry.associatePackets(result, PacketRegistry.reverse((Map)serverMaps.get(protocol)), equivalent, PacketType.Sender.SERVER);
            }
            if (!clientMaps.containsKey(protocol)) continue;
            PacketRegistry.associatePackets(result, PacketRegistry.reverse((Map)clientMaps.get(protocol)), equivalent, PacketType.Sender.CLIENT);
        }
        return result;
    }

    private static <K, V> Map<V, K> reverse(Map<K, V> map) {
        HashMap<V, K> newMap = new HashMap<V, K>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            newMap.put(entry.getValue(), entry.getKey());
        }
        return newMap;
    }

    protected static void associatePackets(Register register, Map<Integer, Class<?>> lookup, PacketType.Protocol protocol, PacketType.Sender sender) {
        for (Map.Entry<Integer, Class<?>> entry : lookup.entrySet()) {
            PacketType type = PacketType.fromCurrent(protocol, sender, entry.getKey(), entry.getValue());
            try {
                register.registerPacket(type, entry.getValue(), sender);
            }
            catch (Exception ex) {
                ProtocolLogger.debug("Encountered an exception associating packet " + type, ex);
            }
        }
    }

    private static void associate(PacketType type, Class<?> clazz) {
        if (clazz != null) {
            REGISTER.typeToClass.put(type, Optional.of(clazz));
            REGISTER.classToType.put(clazz, type);
        } else {
            REGISTER.typeToClass.put(type, Optional.empty());
        }
    }

    private static void initialize() {
        if (!INITIALIZED) {
            INITIALIZED = true;
            REGISTER = MinecraftVersion.BEE_UPDATE.atOrAbove() ? PacketRegistry.createNewRegister() : PacketRegistry.createOldRegister();
        }
    }

    public static boolean isSupported(PacketType type) {
        PacketRegistry.initialize();
        return PacketRegistry.tryGetPacketClass(type).isPresent();
    }

    public static Set<PacketType> getServerPacketTypes() {
        PacketRegistry.initialize();
        PacketRegistry.synchronize();
        return Collections.unmodifiableSet(REGISTER.serverPackets);
    }

    public static Set<PacketType> getClientPacketTypes() {
        PacketRegistry.initialize();
        PacketRegistry.synchronize();
        return Collections.unmodifiableSet(REGISTER.clientPackets);
    }

    private static Class<?> searchForPacket(List<String> classNames) {
        for (String name : classNames) {
            try {
                Class<?> clazz = MinecraftReflection.getMinecraftClass(name);
                if (!MinecraftReflection.getPacketClass().isAssignableFrom(clazz) || Modifier.isAbstract(clazz.getModifiers())) continue;
                return clazz;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Deprecated
    public static Class<?> getPacketClassFromType(PacketType type, boolean forceVanilla) {
        return PacketRegistry.getPacketClassFromType(type);
    }

    public static Optional<Class<?>> tryGetPacketClass(PacketType type) {
        PacketRegistry.initialize();
        Optional res = (Optional)REGISTER.typeToClass.get(type);
        if (res != null) {
            return res;
        }
        Class<?> clazz = PacketRegistry.searchForPacket(type.getClassNames());
        if (clazz != null) {
            ProtocolLogger.warnAbove(type.getCurrentVersion(), "Updating associated class for {0} to {1}", type.name(), clazz);
        }
        PacketRegistry.associate(type, clazz);
        return Optional.ofNullable(clazz);
    }

    public static Class<?> getPacketClassFromType(PacketType type) {
        return PacketRegistry.tryGetPacketClass(type).orElseThrow(() -> new IllegalArgumentException("Could not find packet for type " + type.name()));
    }

    public static PacketType getPacketType(Class<?> packet) {
        PacketRegistry.initialize();
        return (PacketType)REGISTER.classToType.get(packet);
    }

    @Deprecated
    public static PacketType getPacketType(Class<?> packet, PacketType.Sender sender) {
        return PacketRegistry.getPacketType(packet);
    }

    protected static class Register {
        private final Map<PacketType, Optional<Class<?>>> typeToClass = new ConcurrentHashMap();
        private final Map<Class<?>, PacketType> classToType = new ConcurrentHashMap();
        private volatile Set<PacketType> serverPackets = Sets.newHashSet();
        private volatile Set<PacketType> clientPackets = Sets.newHashSet();
        private final List<MapContainer> containers = Lists.newArrayList();

        public void registerPacket(PacketType type, Class<?> clazz, PacketType.Sender sender) {
            this.typeToClass.put(type, Optional.of(clazz));
            this.classToType.put(clazz, type);
            if (sender == PacketType.Sender.CLIENT) {
                this.clientPackets.add(type);
            } else {
                this.serverPackets.add(type);
            }
        }

        public void addContainer(MapContainer container) {
            this.containers.add(container);
        }

        public boolean isOutdated() {
            for (MapContainer container : this.containers) {
                if (!container.hasChanged()) continue;
                return true;
            }
            return false;
        }
    }
}

