/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.collections.IntegerMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class PacketTypeLookup {
    private final ProtocolSenderLookup idLookup = new ProtocolSenderLookup();
    private final ClassLookup classLookup = new ClassLookup();
    private final Multimap<String, PacketType> nameLookup = HashMultimap.create();

    PacketTypeLookup() {
    }

    public PacketTypeLookup addPacketTypes(Iterable<? extends PacketType> types) {
        Preconditions.checkNotNull(types, (Object)"types cannot be NULL");
        for (PacketType packetType : types) {
            if (packetType.getCurrentId() != -1) {
                this.idLookup.getMap(packetType.getProtocol(), packetType.getSender()).put(packetType.getCurrentId(), packetType);
                this.classLookup.getMap(packetType.getProtocol(), packetType.getSender()).put(packetType.getClassNames().get(0), packetType);
            }
            this.nameLookup.put((Object)packetType.name(), (Object)packetType);
        }
        return this;
    }

    @Deprecated
    public PacketType getFromLegacy(int packetId) {
        return null;
    }

    public Collection<PacketType> getFromName(String name) {
        return Collections.unmodifiableCollection(this.nameLookup.get((Object)name));
    }

    @Deprecated
    public PacketType getFromLegacy(int packetId, PacketType.Sender preference) {
        return null;
    }

    @Deprecated
    public PacketType getFromCurrent(PacketType.Protocol protocol, PacketType.Sender sender, int packetId) {
        return this.idLookup.getMap(protocol, sender).get(packetId);
    }

    public PacketType getFromCurrent(PacketType.Protocol protocol, PacketType.Sender sender, String name) {
        return this.classLookup.getMap(protocol, sender).get(name);
    }

    public ClassLookup getClassLookup() {
        return this.classLookup;
    }

    public static class ProtocolSenderLookup {
        public final IntegerMap<PacketType> HANDSHAKE_CLIENT = new IntegerMap();
        public final IntegerMap<PacketType> HANDSHAKE_SERVER = new IntegerMap();
        public final IntegerMap<PacketType> GAME_CLIENT = new IntegerMap();
        public final IntegerMap<PacketType> GAME_SERVER = new IntegerMap();
        public final IntegerMap<PacketType> STATUS_CLIENT = new IntegerMap();
        public final IntegerMap<PacketType> STATUS_SERVER = new IntegerMap();
        public final IntegerMap<PacketType> LOGIN_CLIENT = new IntegerMap();
        public final IntegerMap<PacketType> LOGIN_SERVER = new IntegerMap();
        public final IntegerMap<PacketType> CONFIGURATION_CLIENT = new IntegerMap();
        public final IntegerMap<PacketType> CONFIGURATION_SERVER = new IntegerMap();

        public IntegerMap<PacketType> getMap(PacketType.Protocol protocol, PacketType.Sender sender) {
            switch (protocol) {
                case HANDSHAKING: {
                    return sender == PacketType.Sender.CLIENT ? this.HANDSHAKE_CLIENT : this.HANDSHAKE_SERVER;
                }
                case PLAY: {
                    return sender == PacketType.Sender.CLIENT ? this.GAME_CLIENT : this.GAME_SERVER;
                }
                case STATUS: {
                    return sender == PacketType.Sender.CLIENT ? this.STATUS_CLIENT : this.STATUS_SERVER;
                }
                case LOGIN: {
                    return sender == PacketType.Sender.CLIENT ? this.LOGIN_CLIENT : this.LOGIN_SERVER;
                }
                case CONFIGURATION: {
                    return sender == PacketType.Sender.CLIENT ? this.CONFIGURATION_CLIENT : this.CONFIGURATION_SERVER;
                }
            }
            throw new IllegalArgumentException("Unable to find protocol " + (Object)((Object)protocol));
        }
    }

    public static class ClassLookup {
        public final Map<String, PacketType> HANDSHAKE_CLIENT = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> HANDSHAKE_SERVER = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> GAME_CLIENT = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> GAME_SERVER = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> STATUS_CLIENT = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> STATUS_SERVER = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> LOGIN_CLIENT = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> LOGIN_SERVER = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> CONFIGURATION_CLIENT = new ConcurrentHashMap<String, PacketType>();
        public final Map<String, PacketType> CONFIGURATION_SERVER = new ConcurrentHashMap<String, PacketType>();

        public Map<String, PacketType> getMap(PacketType.Protocol protocol, PacketType.Sender sender) {
            switch (protocol) {
                case HANDSHAKING: {
                    return sender == PacketType.Sender.CLIENT ? this.HANDSHAKE_CLIENT : this.HANDSHAKE_SERVER;
                }
                case PLAY: {
                    return sender == PacketType.Sender.CLIENT ? this.GAME_CLIENT : this.GAME_SERVER;
                }
                case STATUS: {
                    return sender == PacketType.Sender.CLIENT ? this.STATUS_CLIENT : this.STATUS_SERVER;
                }
                case LOGIN: {
                    return sender == PacketType.Sender.CLIENT ? this.LOGIN_CLIENT : this.LOGIN_SERVER;
                }
                case CONFIGURATION: {
                    return sender == PacketType.Sender.CLIENT ? this.CONFIGURATION_CLIENT : this.CONFIGURATION_SERVER;
                }
            }
            throw new IllegalArgumentException("Unable to find protocol " + (Object)((Object)protocol));
        }
    }
}

