/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.concurrency;

import com.comphenix.protocol.utility.SafeCacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;

public class BlockingHashMap<TKey, TValue> {
    private final ConcurrentMap<TKey, TValue> backingMap = SafeCacheBuilder.newBuilder().weakValues().removalListener(new RemovalListener<TKey, TValue>(){

        public void onRemoval(RemovalNotification<TKey, TValue> entry) {
            if (entry.getCause() != RemovalCause.REPLACED) {
                BlockingHashMap.this.locks.remove(entry.getKey());
            }
        }
    }).build(BlockingHashMap.newInvalidCacheLoader());
    private final ConcurrentMap<TKey, Object> locks = new ConcurrentHashMap<TKey, Object>();

    public static <TKey, TValue> CacheLoader<TKey, TValue> newInvalidCacheLoader() {
        return new CacheLoader<TKey, TValue>(){

            public TValue load(TKey key) throws Exception {
                throw new IllegalStateException("Illegal use. Access the map directly instead.");
            }
        };
    }

    public static <TKey, TValue> BlockingHashMap<TKey, TValue> create() {
        return new BlockingHashMap<TKey, TValue>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TValue get(TKey key) throws InterruptedException {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be NULL.");
        }
        Object value = this.backingMap.get(key);
        if (value == null) {
            Object lock;
            Object object = lock = this.getLock(key);
            synchronized (object) {
                while (value == null) {
                    lock.wait();
                    value = this.backingMap.get(key);
                }
            }
        }
        return (TValue)value;
    }

    public TValue get(TKey key, long timeout, TimeUnit unit) throws InterruptedException {
        return this.get(key, timeout, unit, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TValue get(TKey key, long timeout, TimeUnit unit, boolean ignoreInterrupted) throws InterruptedException {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be NULL.");
        }
        if (unit == null) {
            throw new IllegalArgumentException("Unit cannot be NULL.");
        }
        if (timeout < 0L) {
            throw new IllegalArgumentException("Timeout cannot be less than zero.");
        }
        Object value = this.backingMap.get(key);
        if (value == null && timeout > 0L) {
            Object lock = this.getLock(key);
            long stopTimeNS = System.nanoTime() + unit.toNanos(timeout);
            Object object = lock;
            synchronized (object) {
                while (value == null) {
                    try {
                        long remainingTime = stopTimeNS - System.nanoTime();
                        if (remainingTime <= 0L) break;
                        TimeUnit.NANOSECONDS.timedWait(lock, remainingTime);
                        value = this.backingMap.get(key);
                    }
                    catch (InterruptedException e) {
                        if (ignoreInterrupted) continue;
                        throw e;
                    }
                }
            }
        }
        return (TValue)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TValue put(TKey key, TValue value) {
        Object lock;
        if (value == null) {
            throw new IllegalArgumentException("This map doesn't support NULL values.");
        }
        TValue previous = this.backingMap.put(key, value);
        Object object = lock = this.getLock(key);
        synchronized (object) {
            lock.notifyAll();
            return previous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TValue putIfAbsent(TKey key, TValue value) {
        if (value == null) {
            throw new IllegalArgumentException("This map doesn't support NULL values.");
        }
        TValue previous = this.backingMap.putIfAbsent(key, value);
        if (previous == null) {
            Object lock;
            Object object = lock = this.getLock(key);
            synchronized (object) {
                lock.notifyAll();
            }
        }
        return previous;
    }

    public int size() {
        return this.backingMap.size();
    }

    public Collection<TValue> values() {
        return this.backingMap.values();
    }

    public Set<TKey> keys() {
        return this.backingMap.keySet();
    }

    private Object getLock(TKey key) {
        Object created;
        Object lock = this.locks.get(key);
        if (lock == null && (lock = this.locks.putIfAbsent(key, created = new Object())) == null) {
            lock = created;
        }
        return lock;
    }
}

