/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector;

import com.comphenix.net.bytebuddy.dynamic.DynamicType;
import com.comphenix.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import com.comphenix.net.bytebuddy.implementation.FixedValue;
import com.comphenix.net.bytebuddy.matcher.ElementMatchers;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.utility.ByteBuddyFactory;
import com.comphenix.protocol.utility.MinecraftMethods;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftRegistryAccess;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.utility.ZeroBuffer;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import com.comphenix.protocol.wrappers.WrappedStreamCodec;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.security.PublicKey;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class StructureCache {
    private static final Map<Class<?>, Supplier<Object>> PACKET_INSTANCE_CREATORS = new ConcurrentHashMap();
    private static final Map<PacketType, StructureModifier<Object>> STRUCTURE_MODIFIER_CACHE = new ConcurrentHashMap<PacketType, StructureModifier<Object>>();
    private static final Object TRICK_INIT_LOCK = new Object();
    private static boolean TRICK_TRIED = false;
    private static Supplier<Object> TRICKED_DATA_SERIALIZER_BASE;
    private static Supplier<Object> TRICKED_DATA_SERIALIZER_JSON;

    public static Object newPacket(Class<?> packetClass) {
        Supplier packetConstructor = PACKET_INSTANCE_CREATORS.computeIfAbsent(packetClass, packetClassKey -> {
            ConstructorAccessor serializerAccessor;
            WrappedStreamCodec streamCodec = PacketRegistry.getStreamCodec(packetClassKey);
            if (streamCodec != null && StructureCache.tryInitTrickDataSerializer()) {
                try {
                    Object serializer = TRICKED_DATA_SERIALIZER_BASE.get();
                    streamCodec.decode(serializer);
                    return () -> streamCodec.decode(serializer);
                }
                catch (Exception exception) {
                    try {
                        Object serializer = TRICKED_DATA_SERIALIZER_JSON.get();
                        streamCodec.decode(serializer);
                        return () -> streamCodec.decode(serializer);
                    }
                    catch (Exception serializer) {
                        // empty catch block
                    }
                }
            }
            if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove() && (serializerAccessor = Accessors.getConstructorAccessorOrNull(packetClassKey, MinecraftReflection.getPacketDataSerializerClass())) != null && StructureCache.tryInitTrickDataSerializer()) {
                try {
                    Object serializer = TRICKED_DATA_SERIALIZER_BASE.get();
                    serializerAccessor.invoke(serializer);
                    return () -> serializerAccessor.invoke(serializer);
                }
                catch (Exception exception) {
                    try {
                        Object serializer = TRICKED_DATA_SERIALIZER_JSON.get();
                        serializerAccessor.invoke(serializer);
                        return () -> serializerAccessor.invoke(serializer);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
            }
            return () -> {
                Object packetInstance = DefaultInstances.DEFAULT.create((Class<?>)packetClassKey);
                Objects.requireNonNull(packetInstance, "Unable to create packet instance for class " + packetClassKey + " - " + StructureCache.tryInitTrickDataSerializer() + " - " + streamCodec);
                return packetInstance;
            };
        });
        return packetConstructor.get();
    }

    public static Object newPacket(PacketType type) {
        return StructureCache.newPacket(PacketRegistry.getPacketClassFromType(type));
    }

    @Deprecated
    public static StructureModifier<Object> getStructure(Class<?> packetType) {
        PacketType type = PacketRegistry.getPacketType(packetType);
        Preconditions.checkNotNull((Object)type, (Object)("No packet type associated with " + packetType));
        return StructureCache.getStructure(type);
    }

    public static StructureModifier<Object> getStructure(PacketType packetType) {
        Preconditions.checkNotNull((Object)packetType, (Object)"type cannot be null");
        return STRUCTURE_MODIFIER_CACHE.computeIfAbsent(packetType, type -> {
            Class<?> packetClass = PacketRegistry.getPacketClassFromType(type);
            if (MinecraftReflection.isBundleDelimiter(packetClass)) {
                packetClass = MinecraftReflection.getPackedBundlePacketClass().get();
            }
            return new StructureModifier(packetClass, MinecraftReflection.getPacketClass(), true);
        });
    }

    public static Object newNullDataSerializer() {
        StructureCache.tryInitTrickDataSerializer();
        return TRICKED_DATA_SERIALIZER_BASE.get();
    }

    static void initTrickDataSerializer() {
        ConstructorAccessor accessor;
        Optional<Class<?>> registryByteBuf = MinecraftReflection.getRegistryFriendlyByteBufClass();
        Object textCompound = WrappedChatComponent.fromText("").getHandle();
        Object compound = Accessors.getConstructorAccessor(MinecraftReflection.getNBTCompoundClass(), new Class[0]).invoke(new Object[0]);
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition baseBuilder = ByteBuddyFactory.getInstance().createSubclass(registryByteBuf.orElse(MinecraftReflection.getPacketDataSerializerClass())).name(MinecraftMethods.class.getPackage().getName() + ".ProtocolLibTricksNmsDataSerializerBase").method(ElementMatchers.takesArguments(MinecraftReflection.getNBTReadLimiterClass()).and(ElementMatchers.returns(ElementMatchers.isSubTypeOf(MinecraftReflection.getNBTBaseClass())))).intercept(FixedValue.value(compound)).method(ElementMatchers.returns(MinecraftReflection.getIChatBaseComponentClass())).intercept(FixedValue.value(textCompound)).method(ElementMatchers.returns(PublicKey.class).and(ElementMatchers.takesNoArguments())).intercept(FixedValue.nullValue());
        Class serializerBase = baseBuilder.make().load(ByteBuddyFactory.getInstance().getClassLoader(), ClassLoadingStrategy.Default.INJECTION).getLoaded();
        if (registryByteBuf.isPresent()) {
            accessor = Accessors.getConstructorAccessor(FuzzyReflection.fromClass(serializerBase, true).getConstructor(FuzzyMethodContract.newBuilder().parameterDerivedOf(ByteBuf.class).parameterDerivedOf(MinecraftReflection.getRegistryAccessClass()).build()));
            TRICKED_DATA_SERIALIZER_BASE = () -> accessor.invoke(new Object[]{new ZeroBuffer(), MinecraftRegistryAccess.get()});
        } else {
            accessor = Accessors.getConstructorAccessor(serializerBase, ByteBuf.class);
            TRICKED_DATA_SERIALIZER_BASE = () -> accessor.invoke(new Object[]{new ZeroBuffer()});
        }
        Class withStringIntercept = baseBuilder.name(MinecraftMethods.class.getPackage().getName() + ".ProtocolLibTricksNmsDataSerializerJson").method(ElementMatchers.returns(String.class).and(ElementMatchers.takesArguments(Integer.TYPE))).intercept(FixedValue.value("{}")).make().load(ByteBuddyFactory.getInstance().getClassLoader(), ClassLoadingStrategy.Default.INJECTION).getLoaded();
        if (registryByteBuf.isPresent()) {
            ConstructorAccessor accessor2 = Accessors.getConstructorAccessor(FuzzyReflection.fromClass(withStringIntercept).getConstructor(FuzzyMethodContract.newBuilder().parameterDerivedOf(ByteBuf.class).parameterDerivedOf(MinecraftReflection.getRegistryAccessClass()).build()));
            TRICKED_DATA_SERIALIZER_JSON = () -> accessor2.invoke(new Object[]{new ZeroBuffer(), MinecraftRegistryAccess.get()});
        } else {
            ConstructorAccessor accessor3 = Accessors.getConstructorAccessor(withStringIntercept, ByteBuf.class);
            TRICKED_DATA_SERIALIZER_JSON = () -> accessor3.invoke(new Object[]{new ZeroBuffer()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean tryInitTrickDataSerializer() {
        if (TRICK_TRIED) {
            if (TRICKED_DATA_SERIALIZER_BASE == null) return false;
            return true;
        }
        Object object = TRICK_INIT_LOCK;
        synchronized (object) {
            if (TRICK_TRIED) {
                if (TRICKED_DATA_SERIALIZER_BASE == null) return false;
                return true;
            }
            try {
                StructureCache.initTrickDataSerializer();
                boolean bl = true;
                return bl;
            }
            catch (Exception exception) {
            }
            finally {
                TRICK_TRIED = true;
            }
            return false;
        }
    }
}

