/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.accessors;

import com.comphenix.protocol.reflect.ExactReflection;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MemorizingFieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.accessors.MethodHandleHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class Accessors {
    private Accessors() {
    }

    public static FieldAccessor[] getFieldAccessorArray(Class<?> clazz, Class<?> fieldClass, boolean forceAccess) {
        return (FieldAccessor[])FuzzyReflection.fromClass(clazz, forceAccess).getFieldListByType(fieldClass).stream().map(Accessors::getFieldAccessor).toArray(FieldAccessor[]::new);
    }

    public static FieldAccessor getFieldAccessor(Class<?> instanceClass, Class<?> fieldClass, boolean forceAccess) {
        Field field = FuzzyReflection.fromClass(instanceClass, forceAccess).getFieldByType(null, fieldClass);
        return Accessors.getFieldAccessor(field);
    }

    public static FieldAccessor getFieldAccessorOrNull(Class<?> clazz, String fieldName, Class<?> fieldType) {
        Field field = ExactReflection.fromClass(clazz, true).findField(fieldName);
        if (field != null && (fieldType == null || fieldType.isAssignableFrom(field.getType()))) {
            return Accessors.getFieldAccessor(field);
        }
        return null;
    }

    public static FieldAccessor getFieldAccessor(Field field) {
        return MethodHandleHelper.getFieldAccessor(field);
    }

    public static FieldAccessor getMemorizing(FieldAccessor inner) {
        return new MemorizingFieldAccessor(inner);
    }

    public static MethodAccessor getMethodAccessor(Class<?> instanceClass, String methodName, Class<?> ... parameters) {
        Method method = ExactReflection.fromClass(instanceClass, true).getMethod(methodName, parameters);
        return Accessors.getMethodAccessor(method);
    }

    public static MethodAccessor getMethodAccessorOrNull(Class<?> clazz, String methodName, Class<?> ... parameters) {
        Method method = ExactReflection.fromClass(clazz, true).findMethod(methodName, parameters);
        return method == null ? null : Accessors.getMethodAccessor(method);
    }

    public static MethodAccessor getMethodAccessor(Method method) {
        return MethodHandleHelper.getMethodAccessor(method);
    }

    public static ConstructorAccessor getConstructorAccessor(Class<?> instanceClass, Class<?> ... parameters) {
        Constructor<?> constructor = ExactReflection.fromClass(instanceClass, true).findConstructor(parameters);
        return Accessors.getConstructorAccessor(constructor);
    }

    public static ConstructorAccessor getConstructorAccessorOrNull(Class<?> clazz, Class<?> ... parameters) {
        Constructor<?> constructor = ExactReflection.fromClass(clazz, true).findConstructor(parameters);
        return constructor == null ? null : Accessors.getConstructorAccessor(constructor);
    }

    public static ConstructorAccessor getConstructorAccessor(Constructor<?> constructor) {
        return MethodHandleHelper.getConstructorAccessor(constructor);
    }
}

