/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.cloning;

import com.comphenix.protocol.reflect.cloning.BukkitCloner;
import com.comphenix.protocol.reflect.cloning.Cloner;
import com.comphenix.protocol.reflect.cloning.CollectionCloner;
import com.comphenix.protocol.reflect.cloning.FieldCloner;
import com.comphenix.protocol.reflect.cloning.ImmutableDetector;
import com.comphenix.protocol.reflect.cloning.NullableCloner;
import com.comphenix.protocol.reflect.instances.DefaultInstances;
import com.comphenix.protocol.reflect.instances.ExistingGenerator;
import com.comphenix.protocol.reflect.instances.InstanceProvider;
import com.google.common.base.Function;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AggregateCloner
implements Cloner {
    public static final AggregateCloner DEFAULT = AggregateCloner.newBuilder().instanceProvider(DefaultInstances.DEFAULT).andThen(BukkitCloner.class).andThen(ImmutableDetector.class).andThen(CollectionCloner.class).andThen(FieldCloner.class).build();
    private List<Cloner> cloners;
    private WeakReference<Object> lastObject;
    private int lastResult;

    public static Builder newBuilder() {
        return new Builder();
    }

    private AggregateCloner() {
    }

    public List<Cloner> getCloners() {
        return Collections.unmodifiableList(this.cloners);
    }

    private void setCloners(Collection<? extends Cloner> cloners) {
        this.cloners = new ArrayList<Cloner>(cloners);
    }

    @Override
    public boolean canClone(Object source) {
        this.lastResult = this.getFirstCloner(source);
        this.lastObject = new WeakReference<Object>(source);
        return this.lastResult >= 0 && this.lastResult < this.cloners.size();
    }

    private int getFirstCloner(Object source) {
        for (int i = 0; i < this.cloners.size(); ++i) {
            if (!this.cloners.get(i).canClone(source)) continue;
            return i;
        }
        return this.cloners.size();
    }

    @Override
    public Object clone(Object source) {
        if (source == null) {
            throw new IllegalAccessError("source cannot be NULL.");
        }
        int index = 0;
        index = this.lastObject != null && this.lastObject.get() == source ? this.lastResult : this.getFirstCloner(source);
        if (index < this.cloners.size()) {
            Cloner cloner = this.cloners.get(index);
            return cloner.clone(source);
        }
        throw new IllegalArgumentException("Cannot clone " + source + " ( " + source.getClass() + "): No cloner is suitable.");
    }

    public static class Builder {
        private final List<Function<BuilderParameters, Cloner>> factories = new ArrayList<Function<BuilderParameters, Cloner>>();
        private final BuilderParameters parameters = new BuilderParameters();

        public Builder instanceProvider(InstanceProvider provider) {
            this.parameters.instanceProvider = provider;
            return this;
        }

        public Builder andThen(Class<? extends Cloner> type) {
            return this.andThen((Function<BuilderParameters, Cloner>)((Function)param -> {
                Object result = ((BuilderParameters)param).typeConstructor.create(type);
                if (result == null) {
                    throw new IllegalStateException("Constructed NULL instead of " + type);
                }
                if (type.isAssignableFrom(result.getClass())) {
                    return (Cloner)result;
                }
                throw new IllegalStateException("Constructed " + result.getClass() + " instead of " + type);
            }));
        }

        public Builder andThen(Function<BuilderParameters, Cloner> factory) {
            this.factories.add(factory);
            return this;
        }

        public AggregateCloner build() {
            AggregateCloner newCloner = new AggregateCloner();
            NullableCloner paramCloner = new NullableCloner(newCloner);
            InstanceProvider paramProvider = this.parameters.instanceProvider;
            this.parameters.aggregateCloner = paramCloner;
            this.parameters.typeConstructor = DefaultInstances.fromArray(ExistingGenerator.fromObjectArray(new Object[]{paramCloner, paramProvider}));
            ArrayList<Cloner> cloners = new ArrayList<Cloner>();
            for (int i = 0; i < this.factories.size(); ++i) {
                Cloner cloner = (Cloner)this.factories.get(i).apply((Object)this.parameters);
                if (cloner == null) {
                    throw new IllegalArgumentException(String.format("Cannot create cloner from %s (%s)", this.factories.get(i), i));
                }
                cloners.add(cloner);
            }
            newCloner.setCloners(cloners);
            return newCloner;
        }
    }

    public static class BuilderParameters {
        private InstanceProvider instanceProvider;
        private Cloner aggregateCloner;
        private InstanceProvider typeConstructor;

        private BuilderParameters() {
        }

        public InstanceProvider getInstanceProvider() {
            return this.instanceProvider;
        }

        public Cloner getAggregateCloner() {
            return this.aggregateCloner;
        }
    }
}

