/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.utility;

import com.comphenix.protocol.injector.netty.NettyByteBufAdapter;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.comphenix.protocol.wrappers.nbt.NbtType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Base64;
import org.bukkit.inventory.ItemStack;

public class StreamSerializer {
    private static final StreamSerializer DEFAULT = new StreamSerializer();
    private static MethodAccessor READ_ITEM_METHOD;
    private static MethodAccessor WRITE_ITEM_METHOD;
    private static MethodAccessor READ_NBT_METHOD;
    private static MethodAccessor WRITE_NBT_METHOD;
    private static MethodAccessor READ_STRING_METHOD;
    private static MethodAccessor WRITE_STRING_METHOD;

    public static StreamSerializer getDefault() {
        return DEFAULT;
    }

    public void serializeVarInt(DataOutputStream destination, int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) break;
            destination.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        destination.writeByte(value);
    }

    public int deserializeVarInt(DataInputStream source) throws IOException {
        int result = 0;
        for (int j = 0; j < 5; j = (int)((byte)(j + 1))) {
            byte nextByte = source.readByte();
            result |= (nextByte & 0x7F) << j * 7;
            if ((nextByte & 0x80) == 128) continue;
            return result;
        }
        throw new RuntimeException("VarInt is too big");
    }

    public void serializeCompound(DataOutputStream output, NbtCompound compound) {
        if (WRITE_NBT_METHOD == null) {
            FuzzyReflection fuzzy = FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true);
            if (MinecraftVersion.CONFIG_PHASE_PROTOCOL_UPDATE.atOrAbove()) {
                FuzzyMethodContract writeNbtContract = FuzzyMethodContract.newBuilder().returnTypeExact(MinecraftReflection.getPacketDataSerializerClass()).parameterExactArray(MinecraftReflection.getNBTBaseClass()).build();
                WRITE_NBT_METHOD = Accessors.getMethodAccessor(fuzzy.getMethod(writeNbtContract));
            } else {
                WRITE_NBT_METHOD = Accessors.getMethodAccessor(fuzzy.getMethodByParameters("writeNbtCompound", MinecraftReflection.getNBTCompoundClass()));
            }
        }
        ByteBuf buf = NettyByteBufAdapter.packetWriter(output);
        if (!MinecraftVersion.CONFIG_PHASE_PROTOCOL_UPDATE.atOrAbove()) {
            buf.writeByte(NbtType.TAG_COMPOUND.getRawID());
        }
        Object handle = compound != null ? NbtFactory.fromBase(compound).getHandle() : null;
        WRITE_NBT_METHOD.invoke(buf, handle);
    }

    public NbtCompound deserializeCompound(DataInputStream input) {
        ByteBuf buf;
        Object nmsCompound;
        if (READ_NBT_METHOD == null) {
            READ_NBT_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByReturnTypeAndParameters("readNbtCompound", MinecraftReflection.getNBTCompoundClass(), new Class[0]));
        }
        return (nmsCompound = READ_NBT_METHOD.invoke(buf = NettyByteBufAdapter.packetReader(input), new Object[0])) == null ? null : NbtFactory.fromNMSCompound(nmsCompound);
    }

    public void serializeString(DataOutputStream output, String text) {
        if (WRITE_STRING_METHOD == null) {
            WRITE_STRING_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("writeString", String.class));
        }
        ByteBuf buf = NettyByteBufAdapter.packetWriter(output);
        WRITE_STRING_METHOD.invoke(buf, text);
    }

    public String deserializeString(DataInputStream input, int maximumLength) {
        if (READ_STRING_METHOD == null) {
            READ_STRING_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByReturnTypeAndParameters("readString", String.class, Integer.TYPE));
        }
        ByteBuf buf = NettyByteBufAdapter.packetReader(input);
        return (String)READ_STRING_METHOD.invoke(buf, maximumLength);
    }

    public String serializeItemStack(ItemStack stack) throws IOException {
        return Base64.getMimeEncoder().encodeToString(this.serializeItemStackToByteArray(stack));
    }

    public ItemStack deserializeItemStack(String input) {
        return this.deserializeItemStackFromByteArray(Base64.getMimeDecoder().decode(input));
    }

    public byte[] serializeItemStackToByteArray(ItemStack stack) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream data = new DataOutputStream(out);){
                this.serializeItemStack(data, stack);
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack deserializeItemStackFromByteArray(byte[] input) {
        if (READ_ITEM_METHOD == null) {
            READ_ITEM_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByReturnTypeAndParameters("readItemStack", MinecraftReflection.getItemStackClass(), new Class[0]));
        }
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])input);
        Object serializer = MinecraftReflection.getPacketDataSerializer(buf);
        try {
            Object nmsItem = READ_ITEM_METHOD.invoke(serializer, new Object[0]);
            ItemStack itemStack = nmsItem != null ? MinecraftReflection.getBukkitItemStack(nmsItem) : null;
            return itemStack;
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)buf);
        }
    }

    public void serializeItemStack(DataOutputStream output, ItemStack stack) throws IOException {
        if (WRITE_ITEM_METHOD == null) {
            WRITE_ITEM_METHOD = Accessors.getMethodAccessor(FuzzyReflection.fromClass(MinecraftReflection.getPacketDataSerializerClass(), true).getMethodByParameters("writeStack", MinecraftReflection.getItemStackClass()));
        }
        ByteBuf buf = Unpooled.buffer();
        Object serializer = MinecraftReflection.getPacketDataSerializer(buf);
        Object nmsItem = MinecraftReflection.getMinecraftItemStack(stack);
        WRITE_ITEM_METHOD.invoke(serializer, nmsItem);
        output.write(this.getBytesAndRelease(buf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytesAndRelease(ByteBuf buf) {
        try {
            if (buf.hasArray()) {
                byte[] byArray = buf.array();
                return byArray;
            }
            byte[] bytes = new byte[buf.readableBytes()];
            buf.readBytes(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            ReferenceCountUtil.safeRelease((Object)buf);
        }
    }
}

