/*
 * Decompiled with CFR 0.152.
 */
package org.simpleyaml.configuration.comments;

import java.io.IOException;
import java.io.Reader;
import org.simpleyaml.configuration.comments.KeyTree;
import org.simpleyaml.configuration.comments.YamlCommentReader;
import org.simpleyaml.configuration.file.YamlConfigurationOptions;

public class YamlCommentParser
extends YamlCommentReader {
    private StringBuilder currentComment;
    private boolean inQuote = false;

    public YamlCommentParser(YamlConfigurationOptions options, Reader reader) {
        super(options, reader);
    }

    public void parse() throws IOException {
        while (this.nextLine()) {
            if (this.isBlank() || this.isComment()) {
                this.appendLine();
                continue;
            }
            this.trackComment();
        }
        this.trackComment();
        this.reader.close();
    }

    private void appendLine() {
        if (this.currentComment == null) {
            this.currentComment = new StringBuilder(this.currentLine);
        } else {
            this.currentComment.append(this.currentLine);
        }
        this.currentComment.append('\n');
    }

    private void trackComment() {
        KeyTree.Node node = this.track();
        if (this.currentComment != null) {
            node.setComment(this.currentComment.toString());
            this.currentComment = null;
        }
        this.setSideComment(node);
    }

    private void setSideComment(KeyTree.Node node) {
        if (this.currentLine != null) {
            int lastSpace = 0;
            char[] chars = this.currentLine.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                int lastC = i > 0 ? chars[i - 1] : 32;
                char c = chars[i];
                if (c == ' ') {
                    lastSpace = i;
                }
                if (this.inQuote) {
                    if ((c != '\'' || lastC == 39 || lastC == 39) && (c != '\"' || lastC == 34)) continue;
                    this.inQuote = false;
                    continue;
                }
                if (c == '\'' && lastC != 39 && lastC != 39 || c == '\"' && lastC != 34) {
                    this.inQuote = true;
                    continue;
                }
                if (c != '#') continue;
                node.setSideComment(this.currentLine.substring(lastSpace));
                break;
            }
        }
    }
}

