/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.Node;
import com.amihaiemil.eoyaml.RtYamlPrinter;
import com.amihaiemil.eoyaml.Scalar;
import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlNode;
import com.amihaiemil.eoyaml.YamlSequence;
import com.amihaiemil.eoyaml.YamlStream;
import com.amihaiemil.eoyaml.exceptions.YamlPrintException;
import com.amihaiemil.eoyaml.exceptions.YamlReadingException;
import java.io.IOException;
import java.io.StringWriter;

abstract class BaseYamlNode
implements YamlNode {
    BaseYamlNode() {
    }

    @Override
    public final Scalar asScalar() throws YamlReadingException, ClassCastException {
        return this.asClass(Scalar.class, Node.SCALAR);
    }

    @Override
    public final YamlMapping asMapping() throws YamlReadingException, ClassCastException {
        return this.asClass(YamlMapping.class, Node.MAPPING);
    }

    @Override
    public final YamlSequence asSequence() throws YamlReadingException, ClassCastException {
        return this.asClass(YamlSequence.class, Node.SEQUENCE);
    }

    @Override
    public final YamlStream asStream() throws YamlReadingException, ClassCastException {
        return this.asClass(YamlStream.class, Node.STREAM);
    }

    @Override
    public final <T extends YamlNode> T asClass(Class<T> clazz, Node type) throws YamlReadingException, ClassCastException {
        if (this.type() != type) {
            throw new YamlReadingException("The YamlNode is not a " + clazz.getSimpleName() + '!');
        }
        return (T)((YamlNode)clazz.cast(this));
    }

    public final String toString() {
        StringWriter writer = new StringWriter();
        RtYamlPrinter printer = new RtYamlPrinter(writer);
        try {
            printer.print(this);
            return writer.toString();
        }
        catch (IOException ex) {
            throw new YamlPrintException("IOException when printing YAML", ex);
        }
    }
}

