/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.YamlLine;
import com.amihaiemil.eoyaml.YamlLines;
import com.amihaiemil.eoyaml.YamlNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

final class Skip
implements YamlLines {
    private final YamlLines yamlLines;
    private final Condition[] conditions;

    Skip(YamlLines yamlLines, Condition ... conditions) {
        this.yamlLines = yamlLines;
        this.conditions = conditions;
    }

    @Override
    public Iterator<YamlLine> iterator() {
        Iterator<YamlLine> iterator = this.yamlLines.iterator();
        if (iterator.hasNext()) {
            ArrayList<YamlLine> notSkipped = new ArrayList<YamlLine>();
            YamlLine previous = new YamlLine.NullYamlLine();
            while (iterator.hasNext()) {
                boolean skip = false;
                YamlLine next = iterator.next();
                Line current = new Line(next, previous);
                previous = current;
                for (int idx = 0; idx < this.conditions.length; ++idx) {
                    if (!this.conditions[idx].isMet(current)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                notSkipped.add(current.unwrap());
            }
            iterator = notSkipped.iterator();
        }
        return iterator;
    }

    @Override
    public Collection<YamlLine> original() {
        return this.yamlLines.original();
    }

    @Override
    public YamlNode toYamlNode(YamlLine prev, boolean guessIndentation) {
        return this.yamlLines.toYamlNode(prev, guessIndentation);
    }

    static final class Line
    implements YamlLine {
        private final YamlLine current;
        private final YamlLine previous;
        private YamlLine stored;

        private Line(YamlLine current, YamlLine previous) {
            YamlLine store;
            this.current = current;
            this.previous = previous;
            if (previous instanceof Line) {
                Line prevLine = (Line)previous;
                store = prevLine.stored;
            } else {
                store = new YamlLine.NullYamlLine();
            }
            this.stored = store;
        }

        @Override
        public String trimmed() {
            return this.current.trimmed();
        }

        @Override
        public String contents(int previousIndent) {
            return this.current.contents(previousIndent);
        }

        @Override
        public String comment() {
            return this.current.comment();
        }

        @Override
        public int number() {
            return this.current.number();
        }

        @Override
        public int indentation() {
            return this.current.indentation();
        }

        @Override
        public boolean requireNestedIndentation() {
            return this.current.requireNestedIndentation();
        }

        @Override
        public int compareTo(YamlLine other) {
            return this.current.compareTo(other);
        }

        YamlLine getPrevious() {
            return this.previous;
        }

        void store(YamlLine line) {
            this.stored = line;
        }

        YamlLine getStored() {
            return this.stored;
        }

        private YamlLine unwrap() {
            return this.current;
        }
    }

    static interface Condition {
        public boolean isMet(YamlLine var1);
    }
}

