/*
 * Decompiled with CFR 0.152.
 */
package com.amihaiemil.eoyaml;

import com.amihaiemil.eoyaml.JsonYamlMapping;
import com.amihaiemil.eoyaml.JsonYamlSequence;
import com.amihaiemil.eoyaml.ReflectedYamlDump;
import com.amihaiemil.eoyaml.RtYamlInput;
import com.amihaiemil.eoyaml.RtYamlMappingBuilder;
import com.amihaiemil.eoyaml.RtYamlPrinter;
import com.amihaiemil.eoyaml.RtYamlScalarBuilder;
import com.amihaiemil.eoyaml.RtYamlSequenceBuilder;
import com.amihaiemil.eoyaml.RtYamlStreamBuilder;
import com.amihaiemil.eoyaml.YamlDump;
import com.amihaiemil.eoyaml.YamlInput;
import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlMappingBuilder;
import com.amihaiemil.eoyaml.YamlPrinter;
import com.amihaiemil.eoyaml.YamlScalarBuilder;
import com.amihaiemil.eoyaml.YamlSequence;
import com.amihaiemil.eoyaml.YamlSequenceBuilder;
import com.amihaiemil.eoyaml.YamlStreamBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Writer;
import javax.json.JsonArray;
import javax.json.JsonObject;

public final class Yaml {
    private Yaml() {
    }

    public static YamlMappingBuilder createYamlMappingBuilder() {
        return new RtYamlMappingBuilder();
    }

    public static YamlSequenceBuilder createYamlSequenceBuilder() {
        return new RtYamlSequenceBuilder();
    }

    public static YamlScalarBuilder createYamlScalarBuilder() {
        return new RtYamlScalarBuilder();
    }

    public static YamlStreamBuilder createYamlStreamBuilder() {
        return new RtYamlStreamBuilder();
    }

    public static YamlInput createYamlInput(File input) throws FileNotFoundException {
        return Yaml.createYamlInput(input, (boolean)Boolean.FALSE);
    }

    public static YamlInput createYamlInput(File input, boolean guessIndentation) throws FileNotFoundException {
        return Yaml.createYamlInput(new FileInputStream(input), guessIndentation);
    }

    public static YamlInput createYamlInput(String input) {
        return Yaml.createYamlInput(input, (boolean)Boolean.FALSE);
    }

    public static YamlInput createYamlInput(String input, boolean guessIndentation) {
        return Yaml.createYamlInput(new ByteArrayInputStream(input.getBytes()), guessIndentation);
    }

    public static YamlInput createYamlInput(InputStream input) {
        return Yaml.createYamlInput(input, (boolean)Boolean.FALSE);
    }

    public static YamlInput createYamlInput(InputStream input, boolean guessIndentation) {
        return new RtYamlInput(input, guessIndentation);
    }

    public static YamlPrinter createYamlPrinter(Writer destination) {
        return new RtYamlPrinter(destination);
    }

    public static YamlDump createYamlDump(Object object) {
        return new ReflectedYamlDump(object);
    }

    public static YamlMapping fromJsonObject(JsonObject object) {
        return new JsonYamlMapping(object);
    }

    public static YamlSequence fromJsonArray(JsonArray array) {
        return new JsonYamlSequence(array);
    }
}

