/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries;

import com.cryptomorin.xseries.XAttribute;
import com.cryptomorin.xseries.XEntityType;
import com.cryptomorin.xseries.XItemStack;
import com.cryptomorin.xseries.XMaterial;
import com.cryptomorin.xseries.XPotion;
import com.cryptomorin.xseries.reflection.XReflection;
import com.cryptomorin.xseries.reflection.jvm.FieldMemberHandle;
import com.cryptomorin.xseries.reflection.jvm.MethodMemberHandle;
import com.cryptomorin.xseries.reflection.jvm.classes.StaticClassHandle;
import com.google.common.base.Enums;
import com.google.common.base.Strings;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.TreeSpecies;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Boss;
import org.bukkit.entity.Cat;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.GlowSquid;
import org.bukkit.entity.Goat;
import org.bukkit.entity.Hoglin;
import org.bukkit.entity.Husk;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Mob;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Raider;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Spellcaster;
import org.bukkit.entity.Strider;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Vex;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.AbstractHorseInventory;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XEntity {
    public static final Set<EntityType> UNDEAD;
    private static final boolean SUPPORTS_DELAYED_SPAWN;
    private static final MethodHandle DELAYED_SPAWN_1_17;
    private static final MethodHandle DELAYED_SPAWN_1_16_5;
    private static final MethodHandle DELAYED_SPAWN_1_11;
    private static final Object REGISTRY_CAT_VARIANT;
    private static Object REGISTRY_DEFAULT_CAT_VARIANT;
    private static final Map<Class<?>, BiConsumer<Entity, ConfigurationSection>> MAPPING;
    private static final boolean SUPPORTS_Villager_setVillagerLevel;
    private static final boolean SUPPORTS_Villager_setVillagerExperience;
    private static final boolean SUPPORTS_Villager_setVillagerType;

    private static <T extends Entity> void register(Class<T> entityType, BiConsumer<T, ConfigurationSection> handler) {
        MAPPING.put(entityType, (BiConsumer)XEntity.cast(handler));
    }

    private static void mapObjectToConfig(Class<? extends Entity> entityClass) {
        ArrayList<MappedConfigObject> mappedConfigObjects = new ArrayList<MappedConfigObject>();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        for (Method method : entityClass.getDeclaredMethods()) {
            MethodHandle setter;
            String name = method.getName();
            if (!name.startsWith("set")) continue;
            String configEntry = name.substring(3).replaceAll("[A-Z]", "-");
            if (configEntry.startsWith("-")) {
                configEntry = name.charAt(3) + configEntry.substring(1);
            }
            try {
                setter = lookup.unreflect(method);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            mappedConfigObjects.add(new MappedConfigObject(configEntry, setter, null));
        }
    }

    private XEntity() {
    }

    private static Object supportsRegistry(String name) {
        try {
            Object registryClass = XReflection.ofMinecraft().inPackage("org.bukkit").named("Registry").reflect();
            return ((FieldMemberHandle)XReflection.of(registryClass).field().asStatic().getter().named(name).returns((Class)registryClass)).reflect().invoke();
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private static <T> T getRegistryOrEnum(Class<T> typeClass, Object registry, String name, Object defaultValue) {
        if (Strings.isNullOrEmpty((String)name)) {
            return (T)defaultValue;
        }
        T type = registry != null ? XEntity.cast(((Registry)registry).get(XEntity.fromConfig(name))) : XEntity.cast(Enums.getIfPresent((Class)((Class)XEntity.cast(typeClass)), (String)name.toUpperCase(Locale.ENGLISH)).orNull());
        if (type == null) {
            return (T)defaultValue;
        }
        return type;
    }

    private static <T> T cast(Object something) {
        return (T)something;
    }

    private static NamespacedKey fromConfig(String name) {
        NamespacedKey namespacedKey = !name.contains(":") ? NamespacedKey.minecraft((String)name.toLowerCase(Locale.ENGLISH)) : NamespacedKey.fromString((String)name.toLowerCase(Locale.ENGLISH));
        return Objects.requireNonNull(namespacedKey, () -> "Invalid namespace key: " + name);
    }

    @NotNull
    private static Cat.Type getCatVariant(@Nullable String name) {
        if (REGISTRY_DEFAULT_CAT_VARIANT == null) {
            REGISTRY_DEFAULT_CAT_VARIANT = XEntity.getRegistryOrEnum(Cat.Type.class, REGISTRY_CAT_VARIANT, "TABBY", null);
        }
        return XEntity.getRegistryOrEnum(Cat.Type.class, REGISTRY_CAT_VARIANT, name, REGISTRY_DEFAULT_CAT_VARIANT);
    }

    public static boolean isUndead(@Nullable EntityType type) {
        return type != null && UNDEAD.contains(type);
    }

    @Nullable
    public static Entity spawn(@NotNull Location location, @NotNull ConfigurationSection config) {
        Objects.requireNonNull(location, "Cannot spawn entity at a null location.");
        Objects.requireNonNull(config, "Cannot spawn entity from a null configuration section");
        String typeStr = config.getString("type");
        if (typeStr == null) {
            return null;
        }
        Optional<XEntityType> type = XEntityType.of(typeStr);
        if (!type.isPresent()) {
            return null;
        }
        XEntityType finalType = type.get().or(XEntityType.ZOMBIE);
        if (!finalType.isSupported()) {
            return null;
        }
        return XEntity.spawn(location, finalType.get().getEntityClass(), false, entity -> XEntity.edit(entity, config));
    }

    @NotNull
    public static <T extends Entity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, boolean randomizeData, @Nullable java.util.function.Consumer<? super T> function) {
        if (SUPPORTS_DELAYED_SPAWN) {
            return (T)location.getWorld().spawn(location, clazz, randomizeData, function);
        }
        if (DELAYED_SPAWN_1_17 != null) {
            try {
                return (T)DELAYED_SPAWN_1_17.invoke(location.getWorld(), location, clazz, randomizeData, XEntity.toBukkitConsumer(function));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (DELAYED_SPAWN_1_11 != null) {
            try {
                return (T)DELAYED_SPAWN_1_11.invoke(location.getWorld(), location, clazz, XEntity.toBukkitConsumer(function));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        Entity entity = location.getWorld().spawn(location, clazz);
        if (function != null) {
            function.accept(entity);
        }
        return (T)entity;
    }

    @NotNull
    public static <T extends LivingEntity> T spawn(@NotNull Location location, @NotNull Class<T> clazz, @NotNull CreatureSpawnEvent.SpawnReason spawnReason, boolean randomizeData, @Nullable java.util.function.Consumer<? super T> function) {
        if (SUPPORTS_DELAYED_SPAWN) {
            return (T)location.getWorld().spawn(location, clazz, spawnReason, randomizeData, function);
        }
        if (!randomizeData && DELAYED_SPAWN_1_17 != null) {
            try {
                return (T)DELAYED_SPAWN_1_17.invoke(location.getWorld(), location, clazz, randomizeData, XEntity.toBukkitConsumer(function));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (DELAYED_SPAWN_1_16_5 != null) {
            try {
                return (T)DELAYED_SPAWN_1_16_5.invoke(location.getWorld(), location, clazz, spawnReason, XEntity.toBukkitConsumer(function));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        if (DELAYED_SPAWN_1_11 != null) {
            try {
                return (T)DELAYED_SPAWN_1_11.invoke(location.getWorld(), location, clazz, XEntity.toBukkitConsumer(function));
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        LivingEntity entity = (LivingEntity)location.getWorld().spawn(location, clazz);
        if (function != null) {
            function.accept(entity);
        }
        return (T)entity;
    }

    @Nullable
    @Contract(value="!null -> !null")
    private static <T> Consumer<T> toBukkitConsumer(final @Nullable java.util.function.Consumer<T> consumer) {
        if (consumer == null) {
            return null;
        }
        return new Consumer<T>(){

            public void accept(T t) {
                consumer.accept(t);
            }
        };
    }

    private static void map(Class<?> target, Entity entity, ConfigurationSection config) {
        Class<?> superclass;
        if (target == Entity.class) {
            return;
        }
        BiConsumer<Entity, ConfigurationSection> mapping = MAPPING.get(target);
        if (mapping != null) {
            mapping.accept(entity, config);
        }
        if ((superclass = target.getSuperclass()) != null) {
            XEntity.map(superclass, entity, config);
        }
        for (Class<?> interf : target.getInterfaces()) {
            XEntity.map(interf, entity, config);
        }
    }

    @NotNull
    public static Entity edit(@NotNull Entity entity, @NotNull ConfigurationSection config) {
        int live;
        Objects.requireNonNull(entity, "Cannot edit properties of a null entity");
        Objects.requireNonNull(config, "Cannot edit an entity from a null configuration section");
        String name = config.getString("name");
        if (name != null) {
            entity.setCustomName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            entity.setCustomNameVisible(true);
        }
        if (config.isSet("glowing")) {
            entity.setGlowing(config.getBoolean("glowing"));
        }
        if (config.isSet("gravity")) {
            entity.setGravity(config.getBoolean("gravity"));
        }
        if (config.isSet("silent")) {
            entity.setSilent(config.getBoolean("silent"));
        }
        entity.setFireTicks(config.getInt("fire-ticks"));
        entity.setFallDistance((float)config.getInt("fall-distance"));
        if (config.isSet("invulnerable")) {
            entity.setInvulnerable(config.getBoolean("invulnerable"));
        }
        if ((live = config.getInt("ticks-lived")) > 0) {
            entity.setTicksLived(live);
        }
        if (config.isSet("portal-cooldown")) {
            entity.setPortalCooldown(config.getInt("portal-cooldown", -1));
        }
        if (XReflection.supports(13) && entity instanceof Boss) {
            Boss boss = (Boss)entity;
            ConfigurationSection bossBarSection = config.getConfigurationSection("bossbar");
            if (bossBarSection != null) {
                BossBar bossBar = boss.getBossBar();
                XEntity.editBossBar(bossBar, bossBarSection);
            }
        }
        if (entity instanceof Vehicle && entity instanceof Boat) {
            com.google.common.base.Optional species;
            Boat boat = (Boat)entity;
            String speciesName = config.getString("tree-species");
            if (speciesName != null && (species = Enums.getIfPresent(TreeSpecies.class, (String)speciesName)).isPresent()) {
                boat.setWoodType((TreeSpecies)species.get());
            }
        }
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (config.isSet("health")) {
                double hp = config.getDouble("health");
                living.getAttribute((Attribute)XAttribute.MAX_HEALTH.get()).setBaseValue(hp);
                living.setHealth(hp);
            }
            if (XReflection.supports(14)) {
                living.setAbsorptionAmount((double)config.getInt("absorption"));
            }
            if (config.isSet("AI")) {
                living.setAI(config.getBoolean("AI"));
            }
            if (config.isSet("can-pickup-items")) {
                living.setCanPickupItems(config.getBoolean("can-pickup-items"));
            }
            if (config.isSet("collidable")) {
                living.setCollidable(config.getBoolean("collidable"));
            }
            if (config.isSet("gliding")) {
                living.setGliding(config.getBoolean("gliding"));
            }
            if (config.isSet("remove-when-far-away")) {
                living.setRemoveWhenFarAway(config.getBoolean("remove-when-far-away"));
            }
            if (XReflection.supports(13) && config.isSet("swimming")) {
                living.setSwimming(config.getBoolean("swimming"));
            }
            if (config.isSet("max-air")) {
                living.setMaximumAir(config.getInt("max-air"));
            }
            if (config.isSet("no-damage-ticks")) {
                living.setNoDamageTicks(config.getInt("no-damage-ticks"));
            }
            if (config.isSet("remaining-air")) {
                living.setRemainingAir(config.getInt("remaining-air"));
            }
            XPotion.addEffects(living, config.getStringList("effects"));
            ConfigurationSection equip = config.getConfigurationSection("equipment");
            if (equip != null) {
                ConfigurationSection offHand;
                ConfigurationSection mainHand;
                ConfigurationSection boots;
                ConfigurationSection leggings;
                ConfigurationSection chestplate;
                EntityEquipment equipment = living.getEquipment();
                boolean isMob = entity instanceof Mob;
                ConfigurationSection helmet = equip.getConfigurationSection("helmet");
                if (helmet != null) {
                    equipment.setHelmet(XItemStack.deserialize(helmet.getConfigurationSection("item")));
                    if (isMob) {
                        equipment.setHelmetDropChance((float)helmet.getInt("drop-chance"));
                    }
                }
                if ((chestplate = equip.getConfigurationSection("chestplate")) != null) {
                    equipment.setChestplate(XItemStack.deserialize(chestplate.getConfigurationSection("item")));
                    if (isMob) {
                        equipment.setChestplateDropChance((float)chestplate.getInt("drop-chance"));
                    }
                }
                if ((leggings = equip.getConfigurationSection("leggings")) != null) {
                    equipment.setLeggings(XItemStack.deserialize(leggings.getConfigurationSection("item")));
                    if (isMob) {
                        equipment.setLeggingsDropChance((float)leggings.getInt("drop-chance"));
                    }
                }
                if ((boots = equip.getConfigurationSection("boots")) != null) {
                    equipment.setBoots(XItemStack.deserialize(boots.getConfigurationSection("item")));
                    if (isMob) {
                        equipment.setBootsDropChance((float)boots.getInt("drop-chance"));
                    }
                }
                if ((mainHand = equip.getConfigurationSection("main-hand")) != null) {
                    equipment.setItemInMainHand(XItemStack.deserialize(mainHand.getConfigurationSection("item")));
                    if (isMob) {
                        equipment.setItemInMainHandDropChance((float)mainHand.getInt("drop-chance"));
                    }
                }
                if ((offHand = equip.getConfigurationSection("off-hand")) != null) {
                    equipment.setItemInOffHand(XItemStack.deserialize(offHand.getConfigurationSection("item")));
                    if (isMob) {
                        equipment.setItemInOffHandDropChance((float)offHand.getInt("drop-chance"));
                    }
                }
            }
            if (living instanceof Ageable) {
                int age;
                Ageable ageable = (Ageable)living;
                if (config.isSet("breed")) {
                    ageable.setBreed(config.getBoolean("breed"));
                }
                if (config.isSet("baby")) {
                    if (config.getBoolean("baby")) {
                        ageable.setBaby();
                    } else {
                        ageable.setAdult();
                    }
                }
                if ((age = config.getInt("age", 0)) > 0) {
                    ageable.setAge(age);
                }
                if (config.isSet("age-lock")) {
                    ageable.setAgeLock(config.getBoolean("age-lock"));
                }
                if (living instanceof Animals) {
                    Animals animals = (Animals)living;
                    int loveModeTicks = config.getInt("love-mode");
                    if (loveModeTicks != 0) {
                        animals.setLoveModeTicks(loveModeTicks);
                    }
                    if (living instanceof Tameable) {
                        Tameable tam = (Tameable)living;
                        tam.setTamed(config.getBoolean("tamed"));
                    }
                }
            }
            if (living instanceof Sittable) {
                Sittable sit = (Sittable)living;
                sit.setSitting(config.getBoolean("sitting"));
            }
            if (living instanceof Spellcaster) {
                Spellcaster caster = (Spellcaster)living;
                String spell = config.getString("spell");
                if (spell != null) {
                    caster.setSpell((Spellcaster.Spell)Enums.getIfPresent(Spellcaster.Spell.class, (String)spell).or((Object)Spellcaster.Spell.NONE));
                }
            }
            if (living instanceof AbstractHorse) {
                ConfigurationSection items;
                AbstractHorse horse = (AbstractHorse)living;
                if (config.isSet("domestication")) {
                    horse.setDomestication(config.getInt("domestication"));
                }
                if (config.isSet("jump-strength")) {
                    horse.setJumpStrength(config.getDouble("jump-strength"));
                }
                if (config.isSet("max-domestication")) {
                    horse.setMaxDomestication(config.getInt("max-domestication"));
                }
                if ((items = config.getConfigurationSection("items")) != null) {
                    AbstractHorseInventory inventory = horse.getInventory();
                    for (String key : items.getKeys(false)) {
                        ItemStack item;
                        ConfigurationSection itemSec = items.getConfigurationSection(key);
                        int slot = itemSec.getInt("slot", -1);
                        if (slot == -1 || (item = XItemStack.deserialize(itemSec)) == null) continue;
                        inventory.setItem(slot, item);
                    }
                }
                if (living instanceof ChestedHorse) {
                    ChestedHorse chested = (ChestedHorse)living;
                    boolean hasChest = config.getBoolean("has-chest");
                    if (hasChest) {
                        chested.setCarryingChest(true);
                    }
                }
            }
            XEntity.map(entity.getClass(), entity, config);
            if (living instanceof Villager) {
                Villager villager = (Villager)living;
                if (SUPPORTS_Villager_setVillagerLevel) {
                    villager.setVillagerLevel(config.getInt("level"));
                }
                if (SUPPORTS_Villager_setVillagerExperience) {
                    villager.setVillagerExperience(config.getInt("xp"));
                }
            } else if (living instanceof Enderman) {
                ItemStack item;
                Optional<XMaterial> mat;
                Enderman enderman = (Enderman)living;
                String block = config.getString("carrying");
                if (block != null && (mat = XMaterial.matchXMaterial(block)).isPresent() && (item = mat.get().parseItem()) != null) {
                    enderman.setCarriedMaterial(item.getData());
                }
            } else if (living instanceof Sheep) {
                Sheep sheep = (Sheep)living;
                boolean sheared = config.getBoolean("sheared");
                if (sheared) {
                    sheep.setSheared(true);
                }
            } else if (living instanceof Rabbit) {
                Rabbit rabbit = (Rabbit)living;
                rabbit.setRabbitType((Rabbit.Type)Enums.getIfPresent(Rabbit.Type.class, (String)config.getString("color")).or((Object)Rabbit.Type.WHITE));
            } else if (living instanceof Bat) {
                Bat bat = (Bat)living;
                if (!config.getBoolean("awake")) {
                    bat.setAwake(false);
                }
            } else if (living instanceof Wolf) {
                Wolf wolf = (Wolf)living;
                wolf.setAngry(config.getBoolean("angry"));
                wolf.setCollarColor((DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("color")).or((Object)DyeColor.GREEN));
            } else if (living instanceof Creeper) {
                Creeper creeper = (Creeper)living;
                creeper.setExplosionRadius(config.getInt("explosion-radius"));
                creeper.setMaxFuseTicks(config.getInt("max-fuse-ticks"));
                creeper.setPowered(config.getBoolean("powered"));
            } else if (XReflection.supports(10) && XReflection.supports(11)) {
                if (living instanceof Llama) {
                    com.google.common.base.Optional color;
                    Llama llama = (Llama)living;
                    if (config.isSet("strength")) {
                        llama.setStrength(config.getInt("strength"));
                    }
                    if ((color = Enums.getIfPresent(Llama.Color.class, (String)config.getString("color"))).isPresent()) {
                        llama.setColor((Llama.Color)color.get());
                    }
                } else if (XReflection.supports(12)) {
                    if (living instanceof Parrot) {
                        Parrot parrot = (Parrot)living;
                        parrot.setVariant((Parrot.Variant)Enums.getIfPresent(Parrot.Variant.class, (String)config.getString("color")).or((Object)Parrot.Variant.RED));
                    }
                    if (XReflection.supports(13)) {
                        XEntity.thirteen(entity, config);
                    }
                    if (XReflection.supports(14)) {
                        XEntity.fourteen(entity, config);
                    }
                    if (XReflection.supports(15)) {
                        XEntity.fifteen(entity, config);
                    }
                    if (XReflection.supports(16)) {
                        XEntity.sixteen(entity, config);
                    }
                    if (XReflection.supports(17)) {
                        XEntity.seventeen(entity, config);
                    }
                }
            }
        } else if (entity instanceof EnderSignal) {
            EnderSignal signal = (EnderSignal)entity;
            signal.setDespawnTimer(config.getInt("despawn-timer"));
            signal.setDropItem(config.getBoolean("drop-item"));
        } else if (entity instanceof ExperienceOrb) {
            ExperienceOrb orb = (ExperienceOrb)entity;
            orb.setExperience(config.getInt("exp"));
        } else if (entity instanceof Explosive) {
            Explosive explosive = (Explosive)entity;
            explosive.setYield((float)config.getDouble("yield"));
            explosive.setIsIncendiary(config.getBoolean("incendiary"));
        } else if (entity instanceof EnderCrystal) {
            EnderCrystal crystal = (EnderCrystal)entity;
            crystal.setShowingBottom(config.getBoolean("show-bottom"));
        }
        return entity;
    }

    private static void fourteen(Entity entity, ConfigurationSection config) {
        if (entity instanceof Raider) {
            Raider raider = (Raider)entity;
            if (config.isSet("can-join-raid")) {
                raider.setCanJoinRaid(config.getBoolean("can-join-raid"));
            }
            if (config.isSet("is-patrol-leader")) {
                raider.setCanJoinRaid(config.getBoolean("is-patrol-leader"));
            }
        } else if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            cat.setCatType(XEntity.getCatVariant(config.getString("variant")));
            cat.setCollarColor((DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("color")).or((Object)DyeColor.GREEN));
        } else if (entity instanceof Fox) {
            Fox fox = (Fox)entity;
            fox.setCrouching(config.getBoolean("crouching"));
            fox.setSleeping(config.getBoolean("sleeping"));
            fox.setFoxType((Fox.Type)Enums.getIfPresent(Fox.Type.class, (String)config.getString("color")).or((Object)Fox.Type.RED));
        } else if (entity instanceof Panda) {
            Panda panda = (Panda)entity;
            panda.setHiddenGene((Panda.Gene)Enums.getIfPresent(Panda.Gene.class, (String)config.getString("hidden-gene")).or((Object)Panda.Gene.PLAYFUL));
            panda.setMainGene((Panda.Gene)Enums.getIfPresent(Panda.Gene.class, (String)config.getString("main-gene")).or((Object)Panda.Gene.NORMAL));
        } else if (entity instanceof MushroomCow) {
            MushroomCow mooshroom = (MushroomCow)entity;
            mooshroom.setVariant((MushroomCow.Variant)Enums.getIfPresent(MushroomCow.Variant.class, (String)config.getString("color")).or((Object)MushroomCow.Variant.RED));
        }
    }

    private static void thirteen(Entity entity, ConfigurationSection config) {
        if (entity instanceof Husk) {
            Husk husk = (Husk)entity;
            husk.setConversionTime(config.getInt("conversion-time"));
        } else if (entity instanceof Vex) {
            Vex vex = (Vex)entity;
            vex.setCharging(config.getBoolean("charging"));
        } else if (entity instanceof PufferFish) {
            PufferFish pufferFish = (PufferFish)entity;
            pufferFish.setPuffState(config.getInt("puff-state"));
        } else if (entity instanceof TropicalFish) {
            TropicalFish tropicalFish = (TropicalFish)entity;
            tropicalFish.setBodyColor((DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("color")).or((Object)DyeColor.WHITE));
            tropicalFish.setPattern((TropicalFish.Pattern)Enums.getIfPresent(TropicalFish.Pattern.class, (String)config.getString("pattern")).or((Object)TropicalFish.Pattern.BETTY));
            tropicalFish.setPatternColor((DyeColor)Enums.getIfPresent(DyeColor.class, (String)config.getString("pattern-color")).or((Object)DyeColor.WHITE));
        } else if (entity instanceof EnderDragon) {
            EnderDragon dragon = (EnderDragon)entity;
            dragon.setPhase((EnderDragon.Phase)Enums.getIfPresent(EnderDragon.Phase.class, (String)config.getString("phase")).or((Object)EnderDragon.Phase.ROAR_BEFORE_ATTACK));
        } else if (entity instanceof Phantom) {
            Phantom phantom = (Phantom)entity;
            phantom.setSize(config.getInt("size"));
        }
    }

    private static void fifteen(Entity entity, ConfigurationSection config) {
        if (entity instanceof Bee) {
            Bee bee = (Bee)entity;
            bee.setAnger(config.getInt("anger") * 20);
            bee.setHasNectar(config.getBoolean("nectar"));
            bee.setHasStung(config.getBoolean("stung"));
            bee.setCannotEnterHiveTicks(config.getInt("disallow-hive") * 20);
        }
    }

    private static void sixteen(Entity entity, ConfigurationSection config) {
        if (entity instanceof Hoglin) {
            Hoglin hoglin = (Hoglin)entity;
            hoglin.setConversionTime(config.getInt("conversation") * 20);
            hoglin.setImmuneToZombification(config.getBoolean("zombification-immunity"));
            hoglin.setIsAbleToBeHunted(config.getBoolean("can-be-hunted"));
        } else if (entity instanceof Piglin) {
            Piglin piglin = (Piglin)entity;
            piglin.setConversionTime(config.getInt("conversation") * 20);
            piglin.setImmuneToZombification(config.getBoolean("zombification-immunity"));
        } else if (entity instanceof Strider) {
            Strider strider = (Strider)entity;
            strider.setShivering(config.getBoolean("shivering"));
        }
    }

    private static void frog(Entity entity, ConfigurationSection config) {
        Frog frog = (Frog)entity;
        frog.setVariant((Frog.Variant)Registry.FROG_VARIANT.get(XEntity.fromConfig(config.getString("variant"))));
    }

    private static boolean seventeen(Entity entity, ConfigurationSection config) {
        if (entity instanceof Axolotl) {
            com.google.common.base.Optional variant;
            Axolotl axolotl = (Axolotl)entity;
            String variantStr = config.getString("variant");
            if (Strings.isNullOrEmpty((String)variantStr) && (variant = Enums.getIfPresent(Axolotl.Variant.class, (String)variantStr)).isPresent()) {
                axolotl.setVariant((Axolotl.Variant)variant.get());
            }
            if (config.isSet("playing-dead")) {
                axolotl.setPlayingDead(config.getBoolean("playing-dead"));
            }
            return true;
        }
        if (entity instanceof Goat) {
            Goat goat = (Goat)entity;
            if (config.isSet("screaming")) {
                goat.setScreaming(config.getBoolean("screaming"));
            }
            return true;
        }
        if (entity instanceof GlowSquid) {
            GlowSquid glowSquid = (GlowSquid)entity;
            if (config.isSet("dark-ticks-remaining")) {
                glowSquid.setDarkTicksRemaining(config.getInt("dark-ticks-remaining"));
            }
            return true;
        }
        return false;
    }

    public static void editBossBar(BossBar bossBar, ConfigurationSection section) {
        List flagList;
        com.google.common.base.Optional style;
        String styleStr;
        com.google.common.base.Optional color;
        String colorStr;
        String title = section.getString("title");
        if (title != null) {
            bossBar.setTitle(ChatColor.translateAlternateColorCodes((char)'&', (String)title));
        }
        if ((colorStr = section.getString("color")) != null && (color = Enums.getIfPresent(BarColor.class, (String)colorStr.toUpperCase(Locale.ENGLISH))).isPresent()) {
            bossBar.setColor((BarColor)color.get());
        }
        if ((styleStr = section.getString("style")) != null && (style = Enums.getIfPresent(BarStyle.class, (String)styleStr.toUpperCase(Locale.ENGLISH))).isPresent()) {
            bossBar.setStyle((BarStyle)style.get());
        }
        if (!(flagList = section.getStringList("flags")).isEmpty()) {
            EnumSet<BarFlag> flags = EnumSet.noneOf(BarFlag.class);
            for (String flagName : flagList) {
                BarFlag flag = (BarFlag)Enums.getIfPresent(BarFlag.class, (String)flagName.toUpperCase(Locale.ENGLISH)).orNull();
                if (flag == null) continue;
                flags.add(flag);
            }
            for (BarFlag flag : BarFlag.values()) {
                if (flags.contains(flag)) {
                    bossBar.addFlag(flag);
                    continue;
                }
                bossBar.removeFlag(flag);
            }
        }
    }

    static {
        boolean supportsDelayedSpawn;
        REGISTRY_CAT_VARIANT = XEntity.supportsRegistry("CAT_VARIANT");
        MethodHandle delayedSpawn1_17 = null;
        MethodHandle delayedSpawn1_16_5 = null;
        MethodHandle delayedSpawn1_11 = null;
        try {
            World.class.getMethod("spawn", Location.class, Class.class, Boolean.TYPE, java.util.function.Consumer.class);
            supportsDelayedSpawn = true;
        }
        catch (NoSuchMethodException ex) {
            supportsDelayedSpawn = false;
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            delayedSpawn1_17 = lookup.unreflect(World.class.getMethod("spawn", Location.class, Class.class, Boolean.TYPE, Consumer.class));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            delayedSpawn1_16_5 = lookup.unreflect(World.class.getMethod("spawn", Location.class, Class.class, CreatureSpawnEvent.SpawnReason.class, Consumer.class));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            delayedSpawn1_11 = lookup.unreflect(World.class.getMethod("spawn", Location.class, Class.class, Consumer.class));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SUPPORTS_DELAYED_SPAWN = supportsDelayedSpawn;
        DELAYED_SPAWN_1_17 = delayedSpawn1_17;
        DELAYED_SPAWN_1_16_5 = delayedSpawn1_16_5;
        DELAYED_SPAWN_1_11 = delayedSpawn1_11;
        MAPPING = new HashMap(20);
        if (XReflection.supports(19)) {
            XEntity.register(Frog.class, XEntity::frog);
        }
        StaticClassHandle villager = XReflection.of(Villager.class);
        SUPPORTS_Villager_setVillagerLevel = villager.method("void setVillagerLevel(int var1);").exists();
        SUPPORTS_Villager_setVillagerExperience = villager.method("void setVillagerExperience(int xp);").exists();
        SUPPORTS_Villager_setVillagerType = ((MethodMemberHandle)villager.method().named("setVillagerType").returns((Class)Void.TYPE)).parameters(villager.inner(XReflection.ofMinecraft().named("Type"))).exists();
        EnumSet<EntityType[]> undead = EnumSet.of(EntityType.SKELETON, new EntityType[]{EntityType.ZOMBIE, EntityType.GIANT, EntityType.ZOMBIE_VILLAGER, EntityType.WITHER, EntityType.WITHER_SKELETON, EntityType.ZOMBIE_HORSE});
        if (XReflection.supports(10)) {
            undead.add((EntityType[])EntityType.HUSK);
            undead.add((EntityType[])EntityType.STRAY);
            if (XReflection.supports(11)) {
                undead.add((EntityType[])EntityType.SKELETON_HORSE);
                if (XReflection.supports(13)) {
                    undead.add((EntityType[])EntityType.DROWNED);
                    undead.add((EntityType[])EntityType.PHANTOM);
                    if (XReflection.supports(16)) {
                        undead.add((EntityType[])EntityType.ZOGLIN);
                        undead.add((EntityType[])EntityType.PIGLIN);
                        undead.add((EntityType[])EntityType.ZOMBIFIED_PIGLIN);
                    }
                }
            }
        }
        if (!XReflection.supports(16)) {
            undead.add((EntityType[])EntityType.valueOf((String)"PIG_ZOMBIE"));
        }
        UNDEAD = Collections.unmodifiableSet(undead);
    }

    private static final class MappedConfigObject {
        private final String configEntry;
        private final MethodHandle setter;
        private final Function<ConfigurationSection, Object> configurationValue;

        private MappedConfigObject(String configEntry, MethodHandle setter, Function<ConfigurationSection, Object> configurationValue) {
            this.configEntry = configEntry;
            this.setter = setter;
            this.configurationValue = configurationValue;
        }

        private void handle(Entity entity, ConfigurationSection config) {
            if (config.isSet(this.configEntry)) {
                try {
                    this.setter.invoke(this.setter, this.configurationValue.apply(config));
                }
                catch (Throwable e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

