/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.profiles;

import com.cryptomorin.xseries.profiles.PlayerUUIDs;
import com.cryptomorin.xseries.profiles.ProfilesCore;
import com.cryptomorin.xseries.profiles.gameprofile.MojangGameProfile;
import com.cryptomorin.xseries.profiles.gameprofile.XGameProfile;
import com.cryptomorin.xseries.profiles.gameprofile.property.XProperty;
import com.cryptomorin.xseries.profiles.objects.transformer.ProfileTransformer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PlayerProfiles {
    public static final String XSERIES_SIG = "XSeries";
    private static final Property XSERIES_GAMEPROFILE_SIGNATURE = XProperty.create("XSeries", "13.5.0").object();
    private static final String TEXTURES_PROPERTY = "textures";
    public static final GameProfile NIL = PlayerProfiles.createGameProfile(PlayerUUIDs.IDENTITY_UUID, "XSeries").object();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String TEXTURES_NBT_PROPERTY_PREFIX = "{\"textures\":{\"SKIN\":{\"url\":\"";
    public static final String TEXTURES_BASE_URL = "http://textures.minecraft.net/texture/";

    public static Optional<Property> getTextureProperty(MojangGameProfile profile) {
        return Optional.ofNullable(profile.getProperty(TEXTURES_PROPERTY));
    }

    @Nullable
    public static String getTextureValue(@NotNull MojangGameProfile profile) {
        Objects.requireNonNull(profile, "Game profile cannot be null");
        return PlayerProfiles.getTextureProperty(profile).map(PlayerProfiles::getPropertyValue).orElse(null);
    }

    @Nullable
    public static String getOriginalValue(@Nullable MojangGameProfile profile) {
        if (profile == null) {
            return null;
        }
        String original = ProfileTransformer.IncludeOriginalValue.getOriginalValue(profile);
        if (original != null) {
            return original;
        }
        return PlayerProfiles.getTextureValue(profile);
    }

    @NotNull
    public static String getPropertyValue(@NotNull Property property) {
        if (ProfilesCore.NULLABILITY_RECORD_UPDATE) {
            return property.value();
        }
        try {
            return ProfilesCore.Property_getValue.invoke(property);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Unable to get a property value: " + property, throwable);
        }
    }

    public static boolean hasTextures(MojangGameProfile profile) {
        return PlayerProfiles.getTextureProperty(profile).isPresent();
    }

    @NotNull
    public static MojangGameProfile profileFromHashAndBase64(String hash, String base64) {
        UUID uuid = UUID.nameUUIDFromBytes(hash.getBytes(StandardCharsets.UTF_8));
        MojangGameProfile profile = PlayerProfiles.createNamelessGameProfile(uuid);
        return PlayerProfiles.setTexturesProperty(profile, base64);
    }

    public static void removeTimestamp(MojangGameProfile profile) {
        JsonObject jsonObject = Optional.ofNullable(PlayerProfiles.getTextureValue(profile)).map(PlayerProfiles::decodeBase64).map(decoded -> new JsonParser().parse(decoded).getAsJsonObject()).orElse(null);
        if (jsonObject == null || !jsonObject.has("timestamp")) {
            return;
        }
        jsonObject.remove("timestamp");
        PlayerProfiles.setTexturesProperty(profile, PlayerProfiles.encodeBase64(GSON.toJson((JsonElement)jsonObject)));
    }

    @Nullable
    public static GameProfile fromResolvableProfile(@Nullable Object profile) throws Throwable {
        if (profile == null) {
            return null;
        }
        if (!(profile instanceof GameProfile) && ProfilesCore.ResolvableProfile_gameProfile != null) {
            profile = ProfilesCore.ResolvableProfile_gameProfile.invoke(profile);
        }
        return (GameProfile)profile;
    }

    @Nullable
    public static Object toResolvableProfile(@Nullable MojangGameProfile profile) throws Throwable {
        if (profile == null) {
            return null;
        }
        if (ProfilesCore.ResolvableProfile$bukkitSupports) {
            return ProfilesCore.ResolvableProfile$constructor.invoke(profile.object());
        }
        return profile;
    }

    public static GameProfile sanitizeProfile(GameProfile gameProfile) {
        if (PlayerUUIDs.isOnlineMode()) {
            return gameProfile;
        }
        MojangGameProfile profile = XGameProfile.of(gameProfile);
        UUID offlineId = PlayerUUIDs.getOfflineUUID(profile.name());
        PlayerUUIDs.ONLINE_TO_OFFLINE.put(profile.id(), offlineId);
        MojangGameProfile clone = PlayerProfiles.createGameProfile(offlineId, profile.name(), profile.properties());
        return clone.object();
    }

    @Contract(pure=true)
    public static MojangGameProfile setTexturesProperty(MojangGameProfile profile, String texture) {
        return profile.copy(x -> x.setProperty(TEXTURES_PROPERTY, texture));
    }

    @Contract(pure=true)
    public static String encodeBase64(String str) {
        return Base64.getEncoder().encodeToString(str.getBytes(StandardCharsets.UTF_8));
    }

    @Nullable
    @Contract(pure=true)
    public static String decodeBase64(String base64) {
        Objects.requireNonNull(base64, "Cannot decode null string");
        try {
            byte[] bytes = Base64.getDecoder().decode(base64);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    @Contract(pure=true)
    public static MojangGameProfile createGameProfile(UUID uuid, String username) {
        return PlayerProfiles.signXSeries(XGameProfile.create(uuid, username));
    }

    @Contract(pure=true)
    public static MojangGameProfile createGameProfile(UUID uuid, String username, PropertyMap properties) {
        return PlayerProfiles.signXSeries(XGameProfile.create(uuid, username, properties));
    }

    @Contract(pure=true)
    public static MojangGameProfile signXSeries(MojangGameProfile profile) {
        return profile.copy(x -> x.setProperty(XSERIES_SIG, XSERIES_GAMEPROFILE_SIGNATURE));
    }

    @Contract(pure=true)
    public static MojangGameProfile createNamelessGameProfile(UUID id) {
        return PlayerProfiles.createGameProfile(id, XSERIES_SIG);
    }
}

