/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.profiles.lock;

import com.cryptomorin.xseries.profiles.lock.FinalizedKeyedLock;
import com.cryptomorin.xseries.profiles.lock.KeyedLock;
import com.cryptomorin.xseries.profiles.lock.NulledKeyedLock;
import com.cryptomorin.xseries.profiles.lock.ReferentialKeyedLock;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class KeyedLockMap<K> {
    private final Map<K, NulledKeyedLock<K, ?>> locks = new HashMap();

    private NulledKeyedLock<K, ?> createLock(K key) {
        return new NulledKeyedLock(this, key);
    }

    public <V> KeyedLock<K, V> lock(K key, Supplier<V> fetcher) {
        Objects.requireNonNull(fetcher, "Value fetcher is null");
        return this.lock(key, (K k) -> fetcher.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> KeyedLock<K, V> lock(K key, Function<K, V> fetcher) {
        NulledKeyedLock lock;
        Objects.requireNonNull(fetcher, "Value fetcher is null");
        Objects.requireNonNull(key, "Key is null");
        V value = fetcher.apply(key);
        if (value != null) {
            return new FinalizedKeyedLock(value);
        }
        Map<K, NulledKeyedLock<K, ?>> map = this.locks;
        synchronized (map) {
            lock = this.locks.computeIfAbsent(key, this::createLock);
            boolean isNew = lock.pendingTasks == 0;
            ++lock.pendingTasks;
            if (isNew) {
                if (lock.tryLock()) {
                    return lock;
                }
                throw new IllegalStateException("Expected first lock holder to be free: " + lock);
            }
        }
        lock.lock();
        return new ReferentialKeyedLock<K, V>(lock, fetcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlock(NulledKeyedLock<K, ?> lock) {
        Map<K, NulledKeyedLock<K, ?>> map = this.locks;
        synchronized (map) {
            --lock.pendingTasks;
            if (lock.pendingTasks <= 0) {
                this.locks.remove(lock.key);
            }
        }
        lock.lock.unlock();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.locks + ')';
    }
}

