/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.messages;

import com.cryptomorin.xseries.reflection.XReflection;
import com.cryptomorin.xseries.reflection.minecraft.MinecraftClassHandle;
import com.cryptomorin.xseries.reflection.minecraft.MinecraftPackage;
import java.lang.invoke.MethodHandle;
import java.util.Objects;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.jetbrains.annotations.ApiStatus;

public final class MessageComponents {
    private static final MethodHandle CraftChatMessage_fromJson;

    public static MessageTextString ofNullable(String text) {
        return text == null ? null : new MessageTextString(text);
    }

    public static MessageTextComponent ofNullable(BaseComponent text) {
        return text == null ? null : new MessageTextComponent(text);
    }

    @ApiStatus.Experimental
    public static Object bungeeToVanilla(BaseComponent component) throws Throwable {
        String json = ComponentSerializer.toString((BaseComponent)component);
        return CraftChatMessage_fromJson.invoke(json);
    }

    public static BaseComponent fromLegacy(String message) {
        return new TextComponent(TextComponent.fromLegacyText((String)message));
    }

    static {
        MethodHandle fromJson;
        MinecraftClassHandle IChatBaseComponentClass = XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.chat").named("IChatBaseComponent");
        try {
            fromJson = XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "util").named("CraftChatMessage").method("public static IChatBaseComponent fromJSON(String jsonMessage)").returns(IChatBaseComponentClass).reflect();
        }
        catch (Throwable ex) {
            fromJson = null;
        }
        CraftChatMessage_fromJson = fromJson;
    }

    public static final class MessageTextString
    implements MessageText {
        private final String string;

        public MessageTextString(String string) {
            this.string = Objects.requireNonNull(string, "Message cannot be null");
        }

        public String toString() {
            return this.getClass().getSimpleName() + '(' + this.string + ')';
        }

        @Override
        public String asString() {
            return this.string;
        }

        @Override
        public BaseComponent asComponent() {
            return MessageComponents.fromLegacy(this.string);
        }
    }

    public static final class MessageTextComponent
    implements MessageText {
        private final BaseComponent component;

        public MessageTextComponent(BaseComponent component) {
            this.component = Objects.requireNonNull(component, "Message cannot be null");
        }

        public String toString() {
            return this.getClass().getSimpleName() + '(' + this.component + ')';
        }

        @Override
        public String asString() {
            return this.component.toLegacyText();
        }

        @Override
        public BaseComponent asComponent() {
            return this.component;
        }
    }

    public static interface MessageText {
        public String asString();

        public BaseComponent asComponent();
    }
}

