/*
 * Decompiled with CFR 0.152.
 */
package org.cube.converter.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cube.converter.converter.enums.RotationType;
import org.cube.converter.model.element.Cube;
import org.cube.converter.model.element.Parent;
import org.cube.converter.model.impl.bedrock.BedrockGeometryModel;
import org.cube.converter.model.impl.java.JavaItemModel;
import org.cube.converter.util.element.Position3V;
import org.cube.converter.util.legacy.RotationUtil;

public class FormatConverter {
    public static JavaItemModel geometryToItemModel(String texture, BedrockGeometryModel geometry, RotationType type) {
        Position3V min = new Position3V(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        Position3V max = new Position3V(0.0f, 0.0f, 0.0f);
        ArrayList<Parent> parents = new ArrayList<Parent>();
        for (Parent old : geometry.getParents()) {
            Parent parent = old.clone();
            for (Map.Entry<Integer, Cube> entry : parent.getCubes().entrySet()) {
                Cube cube = entry.getValue();
                cube.inflate();
                cube.getPivot().setX(-cube.getPivot().getX());
                if (type != RotationType.POST_1_21_6 && type != RotationType.PRE_1_21_6) {
                    boolean pre12160;
                    RotationUtil.rotateBy90r180DegreesIfPossible(cube);
                    boolean bl = pre12160 = type == RotationType.HACKY_PRE_1_21_6;
                    if (!cube.isThereOneAngleOnly()) {
                        RotationUtil.priorityBestAngle(cube, pre12160);
                    }
                    RotationUtil.doHackyRotationIfPossible(cube, pre12160);
                }
                FormatConverter.convertTo1Axis(cube);
                cube.clampToJavaLimitedAngle(type == RotationType.PRE_1_21_6 || type == RotationType.HACKY_PRE_1_21_6);
                FormatConverter.calculateMinMax(cube, min, max);
            }
            parents.add(parent);
        }
        float scale = FormatConverter.calculateMinSize(min, max);
        JavaItemModel model = new JavaItemModel(texture, geometry.getTextureSize());
        model.getParents().addAll(parents);
        FormatConverter.scale(model, scale);
        return model;
    }

    private static void scale(JavaItemModel model, float scale) {
        model.setScale(1.0f / scale);
        for (Parent parent : model.getParents()) {
            for (Map.Entry<Integer, Cube> entry : parent.getCubes().entrySet()) {
                FormatConverter.scale(entry.getValue(), scale);
            }
        }
    }

    private static void scale(Cube cube, float scale) {
        cube.getPosition().scale(scale);
        cube.getSize().scale(scale);
        cube.getPivot().scale(scale);
    }

    private static void calculateMinMax(Cube cube, Position3V min, Position3V max) {
        Position3V from = cube.getPosition().asJavaPosition(cube.getSize());
        Position3V to = from.add(cube.getSize());
        min.setX(Math.min(min.getX(), from.getX()));
        min.setY(Math.min(min.getY(), from.getY()));
        min.setZ(Math.min(min.getZ(), from.getZ()));
        max.setX(Math.max(max.getX(), to.getX()));
        max.setY(Math.max(max.getY(), to.getY()));
        max.setZ(Math.max(max.getZ(), to.getZ()));
    }

    private static float calculateMinSize(Position3V min, Position3V max) {
        Position3V overlapMin = min.getJavaOverlap();
        Position3V overlapMax = max.getJavaOverlap();
        Position3V totalOverlap = overlapMin.add(overlapMax);
        float maxSize = Math.max(totalOverlap.getY(), totalOverlap.getX() + totalOverlap.getZ());
        float division = 32.0f;
        if (totalOverlap.getY() == maxSize && min.getY() < 0.0f || totalOverlap.getY() != maxSize && (min.getX() < 0.0f || min.getZ() < 0.0f)) {
            division = 16.0f;
        }
        return maxSize == 0.0f ? 1.0f : Math.min(1.0f, division / (maxSize + 48.0f));
    }

    public static void convertTo1Axis(Cube cube) {
        float largestAxis = 0.0f;
        float axis = -1.0f;
        List<Float> axes = List.of(Float.valueOf(cube.getRotation().getX()), Float.valueOf(cube.getRotation().getY()), Float.valueOf(cube.getRotation().getZ()));
        int index = 0;
        for (float angle : axes) {
            if (Math.abs(angle) > largestAxis) {
                largestAxis = Math.abs(angle);
                axis = index;
            }
            ++index;
        }
        if (axis != -1.0f) {
            Position3V rotation = cube.getRotation();
            rotation.setX(axis != 0.0f ? 0.0f : -rotation.getX());
            rotation.setY(axis != 1.0f ? 0.0f : -rotation.getY());
            rotation.setZ(axis != 2.0f ? 0.0f : rotation.getZ());
        }
    }
}

