/*
 * Decompiled with CFR 0.152.
 */
package org.cube.converter.data.bedrock;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.cube.converter.util.GsonUtil;

public class BedrockEntityData {
    private final String identifier;
    private final Scripts scripts;
    private final List<RenderController> controllers;
    private final Map<String, String> materials;
    private final Map<String, String> animations;
    private final Map<String, String> textures;
    private final Map<String, String> geometries;

    @Generated
    public BedrockEntityData(String identifier, Scripts scripts, List<RenderController> controllers, Map<String, String> materials, Map<String, String> animations, Map<String, String> textures, Map<String, String> geometries) {
        this.identifier = identifier;
        this.scripts = scripts;
        this.controllers = controllers;
        this.materials = materials;
        this.animations = animations;
        this.textures = textures;
        this.geometries = geometries;
    }

    @Generated
    public String toString() {
        return "BedrockEntityData(identifier=" + this.getIdentifier() + ", scripts=" + this.getScripts() + ", controllers=" + this.getControllers() + ", materials=" + this.getMaterials() + ", animations=" + this.getAnimations() + ", textures=" + this.getTextures() + ", geometries=" + this.getGeometries() + ")";
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public Scripts getScripts() {
        return this.scripts;
    }

    @Generated
    public List<RenderController> getControllers() {
        return this.controllers;
    }

    @Generated
    public Map<String, String> getMaterials() {
        return this.materials;
    }

    @Generated
    public Map<String, String> getAnimations() {
        return this.animations;
    }

    @Generated
    public Map<String, String> getTextures() {
        return this.textures;
    }

    @Generated
    public Map<String, String> getGeometries() {
        return this.geometries;
    }

    public record Scripts(List<String> initialize, List<String> pre_animation, Scale scale, List<Animate> animates) {
        public static Scripts parse(JsonObject object) {
            List<String> initialize = GsonUtil.arrayToList(object.getAsJsonArray("initialize"));
            List<String> pre_animation = GsonUtil.arrayToList(object.getAsJsonArray("pre_animation"));
            Scale scale = new Scale(GsonUtil.getOrDefault(object.get("scale"), "1"), GsonUtil.getOrDefault(object.get("scaleX"), "1"), GsonUtil.getOrDefault(object.get("scaleY"), "1"), GsonUtil.getOrDefault(object.get("scaleZ"), "1"));
            List<Animate> animates = Animate.parse(object.getAsJsonArray("animate"));
            return new Scripts(initialize, pre_animation, scale, animates);
        }

        public static Scripts emptyScript() {
            return new Scripts(List.of(), List.of(), new Scale("1", "1", "1", "1"), List.of());
        }

        public record Scale(String scale, String scaleX, String scaleY, String scaleZ) {
        }

        public record Animate(String name, String expression) {
            private static List<Animate> parse(JsonArray array) {
                if (array == null) {
                    return List.of();
                }
                ArrayList<Animate> animates = new ArrayList<Animate>();
                for (JsonElement element : array) {
                    if (!element.isJsonObject()) {
                        animates.add(new Animate(element.getAsString(), ""));
                        continue;
                    }
                    JsonObject object = element.getAsJsonObject();
                    for (String elementName : object.keySet()) {
                        animates.add(new Animate(elementName, object.get(elementName).getAsString()));
                    }
                }
                return animates;
            }
        }
    }

    public record RenderController(String identifier, String condition) {
        public static List<RenderController> parse(JsonArray array) {
            if (array == null) {
                return List.of();
            }
            ArrayList<RenderController> list = new ArrayList<RenderController>();
            for (JsonElement element : array) {
                if (element.isJsonObject()) {
                    for (String elementName : element.getAsJsonObject().keySet()) {
                        JsonElement element1 = element.getAsJsonObject().get(elementName);
                        if (!element1.isJsonPrimitive()) continue;
                        list.add(new RenderController(elementName, element1.getAsString()));
                    }
                    continue;
                }
                list.add(new RenderController(element.getAsString(), ""));
            }
            return list;
        }
    }
}

