/*
 * Decompiled with CFR 0.152.
 */
package org.cube.converter.model.element;

import lombok.Generated;
import org.cube.converter.util.element.Position3V;
import org.cube.converter.util.element.UVMap;
import org.cube.converter.util.math.MathUtil;

public final class Cube {
    private String parent = "";
    private float inflate = 0.0f;
    private final Position3V pivot;
    private final Position3V position;
    private final Position3V size;
    private final Position3V rotation;
    private final boolean mirror;
    private final UVMap uvMap;

    public void inflate() {
        this.position.set(this.position.add(-this.inflate, -this.inflate, -this.inflate));
        this.size.set(this.size.add(this.inflate, this.inflate, this.inflate));
    }

    public void clampToJavaLimitedAngle(boolean old) {
        Position3V rotation;
        rotation.setX(Math.abs((rotation = this.getRotation()).getX()) == 180.0f ? 0.0f : MathUtil.limitAngle(rotation.getX(), old));
        rotation.setY(Math.abs(rotation.getY()) == 180.0f ? 0.0f : MathUtil.limitAngle(rotation.getY(), old));
        rotation.setZ(Math.abs(rotation.getZ()) == 180.0f ? 0.0f : MathUtil.limitAngle(rotation.getZ(), old));
    }

    public String getAxis() {
        return this.rotation.getX() != 0.0f ? "x" : (this.rotation.getY() != 0.0f ? "y" : "z");
    }

    public int getAxisIndex() {
        return this.rotation.getX() != 0.0f ? 0 : (this.rotation.getY() != 0.0f ? 1 : 2);
    }

    public boolean isThereOneAngleOnly() {
        boolean xOnly = this.rotation.getX() != 0.0f && this.rotation.getY() == 0.0f && this.rotation.getZ() == 0.0f;
        boolean yOnly = this.rotation.getY() != 0.0f && this.rotation.getX() == 0.0f && this.rotation.getZ() == 0.0f;
        boolean zOnly = this.rotation.getZ() != 0.0f && this.rotation.getX() == 0.0f && this.rotation.getY() == 0.0f;
        return xOnly || yOnly || zOnly;
    }

    public Cube clone() {
        Cube cube = new Cube(this.pivot.clone(), this.position.clone(), this.size.clone(), this.rotation.clone(), this.mirror, this.uvMap.clone());
        cube.setParent(this.parent);
        cube.setInflate(this.inflate);
        return cube;
    }

    @Generated
    public Cube(Position3V pivot, Position3V position, Position3V size, Position3V rotation, boolean mirror, UVMap uvMap) {
        this.pivot = pivot;
        this.position = position;
        this.size = size;
        this.rotation = rotation;
        this.mirror = mirror;
        this.uvMap = uvMap;
    }

    @Generated
    public String getParent() {
        return this.parent;
    }

    @Generated
    public float getInflate() {
        return this.inflate;
    }

    @Generated
    public Position3V getPivot() {
        return this.pivot;
    }

    @Generated
    public Position3V getPosition() {
        return this.position;
    }

    @Generated
    public Position3V getSize() {
        return this.size;
    }

    @Generated
    public Position3V getRotation() {
        return this.rotation;
    }

    @Generated
    public boolean isMirror() {
        return this.mirror;
    }

    @Generated
    public UVMap getUvMap() {
        return this.uvMap;
    }

    @Generated
    public void setParent(String parent) {
        this.parent = parent;
    }

    @Generated
    public void setInflate(float inflate) {
        this.inflate = inflate;
    }
}

