/*
 * Decompiled with CFR 0.152.
 */
package org.cube.converter.model.impl.java;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.cube.converter.model.GeneralModel;
import org.cube.converter.model.element.Cube;
import org.cube.converter.model.element.Parent;
import org.cube.converter.util.element.Direction;
import org.cube.converter.util.element.Position2V;
import org.cube.converter.util.element.Position3V;
import org.cube.converter.util.minecraft.Transformation;

public final class JavaItemModel
extends GeneralModel {
    private Transformation defaultTransformation;
    private final String texture;
    private float scale = 1.0f;

    public JavaItemModel(String texture, Position2V textureSize) {
        super(textureSize);
        this.texture = texture;
        this.defaultTransformation = null;
    }

    public JavaItemModel(String texture, Position2V textureSize, Transformation transformation) {
        super(textureSize);
        this.texture = texture;
        this.defaultTransformation = transformation;
    }

    @Override
    public JsonObject compile() {
        JsonObject json = new JsonObject();
        json.addProperty("credit", "Generated by CubeConverter");
        json.add("texture_size", (JsonElement)this.textureSize.toJson());
        JsonObject textures = new JsonObject();
        textures.addProperty("0", this.texture);
        json.add("textures", (JsonElement)textures);
        JsonArray elements = new JsonArray();
        JsonArray groups = new JsonArray();
        for (Parent group : this.getParents()) {
            JsonObject parent = new JsonObject();
            parent.addProperty("name", group.getName());
            parent.add("origin", (JsonElement)group.getPivot().withJavaOffset().toJson());
            parent.addProperty("color", (Number)0);
            JsonArray children = new JsonArray();
            group.getCubes().forEach((k, v) -> children.add((Number)k));
            parent.add("children", (JsonElement)children);
            for (Map.Entry<Integer, Cube> entry : group.getCubes().entrySet()) {
                Cube cube = entry.getValue();
                JsonObject element = new JsonObject();
                element.addProperty("name", (Number)cube.hashCode());
                Position3V from = cube.getPosition().asJavaPosition(cube.getSize());
                element.add("from", (JsonElement)from.toJson());
                element.add("to", (JsonElement)from.add(cube.getSize()).toJson());
                element.add("rotation", (JsonElement)this.compileAxis(cube));
                element.add("faces", (JsonElement)this.compileUV(this.textureSize.getX(), this.textureSize.getY(), cube));
                elements.add((JsonElement)element);
            }
            groups.add((JsonElement)parent);
        }
        json.add("elements", (JsonElement)elements);
        json.add("groups", (JsonElement)groups);
        return json;
    }

    private JsonObject compileAxis(Cube cube) {
        Position3V rotation = cube.getRotation();
        JsonObject object = new JsonObject();
        object.addProperty("angle", (Number)Float.valueOf(rotation.getX() != 0.0f ? rotation.getX() : (rotation.getY() != 0.0f ? rotation.getY() : rotation.getZ())));
        object.addProperty("axis", cube.getAxis());
        object.add("origin", (JsonElement)cube.getPivot().withJavaOffset().toJson());
        return object;
    }

    private JsonObject compileUV(float textureWidth, float textureHeight, Cube element) {
        JsonObject faces = new JsonObject();
        for (Map.Entry<Direction, Float[]> entry : element.getUvMap().toJavaPerfaceUV(textureWidth, textureHeight).getUvMap().entrySet()) {
            if (entry.getValue() == null) continue;
            JsonObject faceDirection = new JsonObject();
            JsonArray array = new JsonArray();
            array.add((Number)entry.getValue()[0]);
            array.add((Number)entry.getValue()[1]);
            array.add((Number)entry.getValue()[2]);
            array.add((Number)entry.getValue()[3]);
            faceDirection.add("uv", (JsonElement)array);
            faceDirection.addProperty("texture", "#0");
            Float uvRotation = element.getUvMap().getUvRotation().get((Object)entry.getKey());
            if (uvRotation != null) {
                faceDirection.addProperty("rotation", (Number)uvRotation);
            }
            faces.add(entry.getKey().name().toLowerCase(), (JsonElement)faceDirection);
        }
        if (faces.isEmpty()) {
            JsonObject face = new JsonObject();
            JsonArray array = new JsonArray();
            List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0)).forEach(arg_0 -> ((JsonArray)array).add(arg_0));
            face.add("uv", (JsonElement)array);
            face.addProperty("texture", "#0");
            faces.add("down", (JsonElement)face);
        }
        return faces;
    }

    public static JavaItemModel fromJson(JsonObject object) {
        return null;
    }

    @Generated
    public Transformation getDefaultTransformation() {
        return this.defaultTransformation;
    }

    @Generated
    public String getTexture() {
        return this.texture;
    }

    @Generated
    public float getScale() {
        return this.scale;
    }

    @Generated
    public void setDefaultTransformation(Transformation defaultTransformation) {
        this.defaultTransformation = defaultTransformation;
    }

    @Generated
    public void setScale(float scale) {
        this.scale = scale;
    }
}

