/*
 * Decompiled with CFR 0.152.
 */
package org.cube.converter.parser.bedrock.controller;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cube.converter.data.bedrock.controller.BedrockRenderController;
import org.cube.converter.util.GsonUtil;

public class BedrockControllerParser {
    public static List<BedrockRenderController> parse(String json) {
        return BedrockControllerParser.parse((JsonObject)GsonUtil.getGson().fromJson(json.trim(), JsonObject.class));
    }

    public static List<BedrockRenderController> parse(JsonObject json) {
        if (!json.has("render_controllers")) {
            return new ArrayList<BedrockRenderController>();
        }
        ArrayList<BedrockRenderController> list = new ArrayList<BedrockRenderController>();
        JsonObject controllers = json.getAsJsonObject("render_controllers");
        for (String identifier : controllers.keySet()) {
            JsonObject arrays;
            JsonElement element;
            if (!controllers.get(identifier).isJsonObject() || !identifier.startsWith("controller.render")) continue;
            JsonObject object = controllers.getAsJsonObject(identifier);
            ArrayList<String> textureExpressions = new ArrayList();
            if (object.has("textures")) {
                textureExpressions = BedrockControllerParser.arrayToList(object.getAsJsonArray("textures"));
            }
            String geometryExpression = "";
            if (object.has("geometry") && (element = object.get("geometry")).isJsonPrimitive()) {
                geometryExpression = element.getAsString();
            }
            HashMap<String, String> materialsMap = new HashMap<String, String>();
            if (object.has("materials")) {
                for (JsonElement element2 : object.getAsJsonArray("materials")) {
                    if (!element2.isJsonObject()) continue;
                    materialsMap.putAll(GsonUtil.objectToMap(element2.getAsJsonObject()));
                }
            }
            if ((arrays = object.getAsJsonObject("arrays")) == null) {
                list.add(new BedrockRenderController(identifier, materialsMap, geometryExpression, textureExpressions, List.of(), List.of(), List.of()));
                continue;
            }
            List<BedrockRenderController.Array> textures = BedrockRenderController.Array.parse(arrays.getAsJsonObject("textures"));
            List<BedrockRenderController.Array> geometries = BedrockRenderController.Array.parse(arrays.getAsJsonObject("geometries"));
            List<BedrockRenderController.Array> materials = BedrockRenderController.Array.parse(arrays.getAsJsonObject("materials"));
            list.add(new BedrockRenderController(identifier, materialsMap, geometryExpression, textureExpressions, materials, textures, geometries));
        }
        return list;
    }

    private static List<String> arrayToList(JsonArray array) {
        ArrayList<String> list = new ArrayList<String>();
        for (JsonElement element : array) {
            list.add(element.getAsString());
        }
        return list;
    }
}

