/*
 * Decompiled with CFR 0.152.
 */
package org.cube.converter.parser.bedrock.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.cube.converter.data.bedrock.BedrockAttachableData;
import org.cube.converter.data.bedrock.BedrockEntityData;
import org.cube.converter.util.GsonUtil;

public class BedrockDataParser {
    public static BedrockEntityData parseEntity(String json) {
        JsonElement element = (JsonElement)GsonUtil.getGson().fromJson(json.trim(), JsonElement.class);
        if (!element.isJsonObject()) {
            return null;
        }
        return BedrockDataParser.parseEntity(element.getAsJsonObject());
    }

    public static BedrockAttachableData parseAttachable(String json) {
        JsonElement element = (JsonElement)GsonUtil.getGson().fromJson(json.trim(), JsonElement.class);
        if (!element.isJsonObject()) {
            return null;
        }
        return BedrockDataParser.parseAttachable(element.getAsJsonObject());
    }

    private static BedrockAttachableData parseAttachable(JsonObject json) {
        return (BedrockAttachableData)BedrockDataParser.parse(json, "minecraft:attachable", true);
    }

    private static BedrockEntityData parseEntity(JsonObject json) {
        return BedrockDataParser.parse(json, "minecraft:client_entity", false);
    }

    private static BedrockEntityData parse(JsonObject json, String identifierName, boolean attachable) {
        if (!json.has(identifierName)) {
            return null;
        }
        JsonObject description = json.getAsJsonObject(identifierName).getAsJsonObject("description");
        String identifier = description.getAsJsonPrimitive("identifier").getAsString();
        Map<String, String> materials = GsonUtil.objectToMap(description.getAsJsonObject("materials"));
        Map<String, String> textures = GsonUtil.objectToMap(description.getAsJsonObject("textures"));
        Map<String, String> geometries = GsonUtil.objectToMap(description.getAsJsonObject("geometry"));
        Map<String, String> animations = GsonUtil.objectToMap(description.getAsJsonObject("animations"));
        List<BedrockEntityData.RenderController> controllers = BedrockEntityData.RenderController.parse(description.getAsJsonArray("render_controllers"));
        BedrockEntityData.Scripts scripts = description.has("scripts") ? BedrockEntityData.Scripts.parse(description.getAsJsonObject("scripts")) : BedrockEntityData.Scripts.emptyScript();
        return attachable ? new BedrockAttachableData(identifier, scripts, controllers, materials, animations, textures, geometries) : new BedrockEntityData(identifier, scripts, controllers, materials, animations, textures, geometries);
    }

    @Generated
    public BedrockDataParser() {
    }
}

