/*
 * Decompiled with CFR 0.152.
 */
package org.cube.converter.parser.bedrock.geometry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import org.cube.converter.model.element.Cube;
import org.cube.converter.model.element.Parent;
import org.cube.converter.model.impl.bedrock.BedrockGeometryModel;
import org.cube.converter.util.GsonUtil;
import org.cube.converter.util.element.Position2V;
import org.cube.converter.util.element.Position3V;
import org.cube.converter.util.element.UVMap;

public class BedrockGeometryParser {
    public static List<BedrockGeometryModel> parse(String json) {
        return BedrockGeometryParser.parse((JsonObject)GsonUtil.getGson().fromJson(json.trim(), JsonObject.class));
    }

    public static List<BedrockGeometryModel> parse(JsonObject json) {
        ArrayList<BedrockGeometryModel> geometries = new ArrayList<BedrockGeometryModel>();
        if (json.has("minecraft:geometry")) {
            JsonElement element = json.get("minecraft:geometry");
            if (!element.isJsonArray()) {
                return null;
            }
            JsonArray array = element.getAsJsonArray();
            for (JsonElement element1 : array) {
                JsonObject object;
                BedrockGeometryModel geometry;
                if (!element1.isJsonObject() || (geometry = BedrockGeometryParser.getGeometry(object = element1.getAsJsonObject(), "minecraft:geometry", "texture_width", "texture_height")) == null) continue;
                geometries.add(geometry);
            }
        }
        for (String elementName : json.keySet()) {
            BedrockGeometryModel geometry;
            JsonObject object;
            JsonElement element = json.get(elementName);
            if (!element.isJsonObject() || !(object = element.getAsJsonObject()).has("texturewidth") || (geometry = BedrockGeometryParser.getGeometry(object, elementName, "texturewidth", "textureheight")) == null) continue;
            geometries.add(geometry);
        }
        return geometries;
    }

    private static BedrockGeometryModel getGeometry(JsonObject geometry, String elementName, String textureWidthName, String textureHeightName) {
        String identifier;
        JsonObject description = geometry.has("description") ? geometry.getAsJsonObject("description") : geometry;
        String string = identifier = description.has("identifier") ? description.get("identifier").getAsString() : elementName;
        if (!description.has(textureHeightName) || !description.has(textureWidthName)) {
            return null;
        }
        int textureWidth = description.get(textureWidthName).getAsInt();
        int textureHeight = description.get(textureHeightName).getAsInt();
        if (!geometry.has("bones")) {
            return null;
        }
        ArrayList<Parent> bones = new ArrayList<Parent>();
        for (JsonElement boneElement : geometry.getAsJsonArray("bones")) {
            JsonObject boneObject = boneElement.getAsJsonObject();
            String name = boneObject.get("name").getAsString();
            Position3V parentPivot = new Position3V(boneObject.getAsJsonArray("pivot"));
            Position3V boneRotation = new Position3V(boneObject.getAsJsonArray("rotation"));
            Parent bone = new Parent(name, parentPivot, boneRotation);
            if (boneObject.has("parent")) {
                bone.setParent(boneObject.get("parent").getAsString());
            }
            if (!boneObject.has("cubes")) {
                bones.add(bone);
                continue;
            }
            int i = 0;
            JsonArray cubeElements = boneObject.getAsJsonArray("cubes");
            for (JsonElement cubeElement : cubeElements) {
                Cube cube;
                JsonObject cubeObject = cubeElement.getAsJsonObject();
                Position3V position = new Position3V(cubeObject.getAsJsonArray("origin"));
                Position3V size = new Position3V(cubeObject.getAsJsonArray("size"));
                Position3V pivot = new Position3V(cubeObject.getAsJsonArray("pivot"));
                Position3V rotation = new Position3V(cubeObject.getAsJsonArray("rotation"));
                boolean mirror = false;
                if (cubeObject.has("mirror")) {
                    mirror = cubeObject.get("mirror").getAsBoolean();
                }
                if (cubeObject.get("uv") instanceof JsonArray) {
                    JsonArray array = cubeObject.getAsJsonArray("uv");
                    Float[] offset = new Float[]{Float.valueOf(array.get(0).getAsFloat()), Float.valueOf(array.get(1).getAsFloat())};
                    cube = new Cube(pivot, position, size, rotation, mirror, UVMap.fromBoxUV(size, offset, mirror));
                } else {
                    cube = new Cube(pivot, position, size, rotation, mirror, UVMap.fromPerfaceUV(cubeObject));
                }
                cube.setParent(bone.getParent());
                if (cubeObject.has("inflate")) {
                    cube.setInflate(cubeObject.get("inflate").getAsFloat());
                }
                bone.getCubes().put(i, cube);
                ++i;
            }
            bones.add(bone);
        }
        BedrockGeometryModel geometryModel = new BedrockGeometryModel(identifier, new Position2V(textureWidth, textureHeight));
        geometryModel.getParents().addAll(bones);
        return geometryModel;
    }
}

