/*
 * Decompiled with CFR 0.152.
 */
package org.cube.converter.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class GsonUtil {
    private static final Gson gson = new GsonBuilder().create();

    private GsonUtil() {
    }

    public static List<String> arrayToList(JsonArray array) {
        if (array == null) {
            return List.of();
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (JsonElement element : array) {
            if (element.isJsonObject()) continue;
            strings.add(element.getAsString());
        }
        return strings;
    }

    public static Map<String, String> objectToMap(JsonObject object) {
        if (object == null) {
            return Map.of();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String name : object.keySet()) {
            JsonElement element = object.get(name);
            map.put(name, element.getAsString());
        }
        return map;
    }

    public static String getOrDefault(JsonElement element, String defaultValue) {
        return element == null ? defaultValue : element.getAsString();
    }

    @Generated
    public static Gson getGson() {
        return gson;
    }
}

