/*
 * Decompiled with CFR 0.152.
 */
package org.cube.converter.util.element;

import com.google.gson.JsonArray;
import lombok.Generated;
import org.cube.converter.util.math.MathUtil;

public final class Position3V {
    private float x;
    private float y;
    private float z;

    public Position3V(JsonArray array) {
        if (array == null) {
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
            return;
        }
        this.x = array.get(0).getAsFloat();
        this.y = array.get(1).getAsFloat();
        this.z = array.get(2).getAsFloat();
    }

    public Position3V(float[] array) {
        this.x = array[0];
        this.y = array[1];
        this.z = array[2];
    }

    public static Position3V zero() {
        return new Position3V(0.0f, 0.0f, 0.0f);
    }

    public static Position3V fromOrigin(JsonArray origin, JsonArray size) {
        float x = -(origin.get(0).getAsFloat() + size.get(0).getAsFloat());
        float y = origin.get(1).getAsFloat();
        float z = origin.get(2).getAsFloat();
        return new Position3V(x, y, z);
    }

    public Position3V getJavaOverlap() {
        Position3V overlap = new Position3V(0.0f, 0.0f, 0.0f);
        overlap.setX(Math.abs(this.x - MathUtil.clamp(this.x, -16.0f, 32.0f)));
        overlap.setY(Math.abs(this.y - MathUtil.clamp(this.y, -16.0f, 32.0f)));
        overlap.setZ(Math.abs(this.z - MathUtil.clamp(this.z, -16.0f, 32.0f)));
        return overlap;
    }

    public void scale(float scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
    }

    public void set(Position3V position3V) {
        this.set(position3V.x, position3V.y, position3V.z);
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Position3V add(Position3V position3V) {
        return this.add(position3V.x, position3V.y, position3V.z);
    }

    public Position3V add(float x, float y, float z) {
        return new Position3V(this.x + x, this.y + y, this.z + z);
    }

    public Position3V subtract(Position3V position3V) {
        return this.subtract(position3V.x, position3V.y, position3V.z);
    }

    public Position3V subtract(float x, float y, float z) {
        return new Position3V(this.x - x, this.y - y, this.z - z);
    }

    public Position3V asJavaPosition(Position3V size) {
        return new Position3V(-(this.x + size.x), this.y, this.z).withJavaOffset();
    }

    public Position3V asBedrockPosition(Position3V size) {
        float newX = this.x - 8.0f;
        return new Position3V(-newX - size.x, this.y, this.z - 8.0f);
    }

    public Position3V withJavaOffset() {
        return new Position3V(this.x + 8.0f, this.y, this.z + 8.0f);
    }

    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    public float[] toArray() {
        return new float[]{this.x, this.y, this.z};
    }

    public Position3V clone() {
        return this.add(0.0f, 0.0f, 0.0f);
    }

    public JsonArray toJson() {
        JsonArray array = new JsonArray();
        array.add((Number)Float.valueOf(this.x));
        array.add((Number)Float.valueOf(this.y));
        array.add((Number)Float.valueOf(this.z));
        return array;
    }

    @Generated
    public Position3V(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Generated
    public String toString() {
        return "Position3V(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }

    @Generated
    public float getX() {
        return this.x;
    }

    @Generated
    public float getY() {
        return this.y;
    }

    @Generated
    public float getZ() {
        return this.z;
    }

    @Generated
    public void setX(float x) {
        this.x = x;
    }

    @Generated
    public void setY(float y) {
        this.y = y;
    }

    @Generated
    public void setZ(float z) {
        this.z = z;
    }
}

