/*
 * Decompiled with CFR 0.152.
 */
package org.cube.converter.util.element;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.cube.converter.util.element.Direction;
import org.cube.converter.util.element.Position3V;
import org.cube.converter.util.minecraft.UVUtil;

public final class UVMap {
    private final UVType uvType;
    private final Map<Direction, Float[]> uvMap = new HashMap<Direction, Float[]>();
    private final Map<Direction, Float> uvRotation = new HashMap<Direction, Float>();

    private UVMap(UVType uvType) {
        this.uvType = uvType;
    }

    public void rotate(Direction direction, int roll) {
        Float[] uv = this.uvMap.get((Object)direction);
        if (uv == null) {
            return;
        }
        float rotation = roll * 90 % 360;
        this.uvRotation.put(direction, Float.valueOf(rotation));
    }

    public UVMap toJavaPerfaceUV(float textureWidth, float textureHeight) {
        UVMap map = new UVMap(UVType.PERFACE);
        for (Map.Entry<Direction, Float[]> entry : this.uvMap.entrySet()) {
            if (entry.getValue() == null) continue;
            Float[] uv = entry.getValue();
            for (int i = 0; i < uv.length; ++i) {
                uv[i] = Float.valueOf(uv[i].floatValue() * 16.0f / (i % 2 == 0 ? textureWidth : textureHeight));
            }
            map.getUvMap().put(entry.getKey(), uv);
        }
        return map;
    }

    public static UVMap fromBoxUV(Position3V size, Float[] offset, boolean mirror) {
        UVMap map = new UVMap(UVType.BOX);
        List<UVUtil.Face> faces = UVUtil.toUvFaces(size, mirror);
        for (UVUtil.Face face : faces) {
            map.getUvMap().put(face.getDirection(), new Float[]{Float.valueOf(face.getStart().getX() + offset[0].floatValue()), Float.valueOf(face.getStart().getY() + offset[1].floatValue()), Float.valueOf(face.getEnd().getX() + offset[0].floatValue()), Float.valueOf(face.getEnd().getY() + offset[1].floatValue())});
        }
        return map;
    }

    public static UVMap fromPerfaceUV(JsonObject object) {
        JsonObject uv = object.getAsJsonObject("uv");
        UVMap map = new UVMap(UVType.PERFACE);
        UVMap.putIfExist(Direction.NORTH, uv, map.getUvMap());
        UVMap.putIfExist(Direction.EAST, uv, map.getUvMap());
        UVMap.putIfExist(Direction.SOUTH, uv, map.getUvMap());
        UVMap.putIfExist(Direction.WEST, uv, map.getUvMap());
        UVMap.putIfExist(Direction.UP, uv, map.getUvMap());
        UVMap.putIfExist(Direction.DOWN, uv, map.getUvMap());
        return map;
    }

    private static void putIfExist(Direction direction, JsonObject object, Map<Direction, Float[]> map) {
        String name = direction.name().toLowerCase();
        if (object.has(name)) {
            map.put(direction, UVMap.getUVDirection(object.getAsJsonObject(name)));
        }
    }

    private static Float[] getUVDirection(JsonObject object) {
        if (object == null) {
            return new Float[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)};
        }
        JsonArray arrayUv = object.getAsJsonArray("uv");
        JsonArray arrayUvSize = object.getAsJsonArray("uv_size");
        return new Float[]{Float.valueOf(arrayUv.get(0).getAsFloat()), Float.valueOf(arrayUv.get(1).getAsFloat()), Float.valueOf(arrayUv.get(0).getAsFloat() + arrayUvSize.get(0).getAsFloat()), Float.valueOf(arrayUv.get(1).getAsFloat() + arrayUvSize.get(1).getAsFloat())};
    }

    public UVMap clone() {
        UVMap map = new UVMap(this.uvType);
        for (Map.Entry<Direction, Float[]> entry : this.uvMap.entrySet()) {
            if (entry.getValue() == null) continue;
            map.getUvMap().put(entry.getKey(), new Float[]{entry.getValue()[0], entry.getValue()[1], entry.getValue()[2], entry.getValue()[3]});
        }
        map.getUvRotation().putAll(this.uvRotation);
        return map;
    }

    @Generated
    public UVType getUvType() {
        return this.uvType;
    }

    @Generated
    public Map<Direction, Float[]> getUvMap() {
        return this.uvMap;
    }

    @Generated
    public Map<Direction, Float> getUvRotation() {
        return this.uvRotation;
    }

    public static enum UVType {
        PERFACE,
        BOX;

    }
}

