/*
 * Decompiled with CFR 0.152.
 */
package org.cube.converter.util.legacy;

import java.util.List;
import org.cube.converter.converter.FormatConverter;
import org.cube.converter.model.element.Cube;
import org.cube.converter.util.element.Direction;
import org.cube.converter.util.element.Position3V;
import org.cube.converter.util.legacy.ArrayUtil;
import org.cube.converter.util.math.MathUtil;

public class RotationUtil {
    public static void rotateBy90r180DegreesIfPossible(Cube cube) {
        if (cube.isThereOneAngleOnly()) {
            return;
        }
        Position3V rotation = cube.getRotation();
        if (MathUtil.closeEnoughAbs(rotation.getX(), 90.0f)) {
            rotation.setX(0.0f);
            RotationUtil.roll(cube, rotation.getX(), 0);
        } else if (MathUtil.closeEnoughAbs(rotation.getX(), 180.0f)) {
            rotation.setX(0.0f);
            RotationUtil.roll(cube, Math.signum(rotation.getX()) * 90.0f, 0);
            RotationUtil.roll(cube, Math.signum(rotation.getX()) * 90.0f, 0);
        }
        if (MathUtil.closeEnoughAbs(rotation.getY(), 90.0f)) {
            rotation.setY(0.0f);
            RotationUtil.roll(cube, rotation.getY(), 1);
        } else if (MathUtil.closeEnoughAbs(rotation.getY(), 180.0f)) {
            rotation.setY(0.0f);
            RotationUtil.roll(cube, Math.signum(rotation.getY()) * 90.0f, 1);
            RotationUtil.roll(cube, Math.signum(rotation.getY()) * 90.0f, 1);
        }
        if (MathUtil.closeEnoughAbs(rotation.getZ(), 90.0f)) {
            rotation.setZ(0.0f);
            RotationUtil.roll(cube, rotation.getZ(), 1);
        } else if (MathUtil.closeEnoughAbs(rotation.getZ(), 180.0f)) {
            rotation.setZ(0.0f);
            RotationUtil.roll(cube, Math.signum(rotation.getZ()) * 90.0f, 2);
            RotationUtil.roll(cube, Math.signum(rotation.getZ()) * 90.0f, 2);
        }
    }

    public static void priorityBestAngle(Cube cube, boolean pre1_21_60) {
        float largestAxis = 0.0f;
        float axis = -1.0f;
        List<Float> axes = List.of(Float.valueOf(cube.getRotation().getX()), Float.valueOf(cube.getRotation().getY()), Float.valueOf(cube.getRotation().getZ()));
        int index = 0;
        for (float angle : axes) {
            if (Math.abs(angle) > largestAxis && MathUtil.canDoHacky(angle, pre1_21_60) && angle != 0.0f) {
                largestAxis = Math.abs(angle);
                axis = index;
            }
            ++index;
        }
        if (axis != -1.0f) {
            Position3V rotation = cube.getRotation();
            rotation.setX(axis != 0.0f ? 0.0f : -rotation.getX());
            rotation.setY(axis != 1.0f ? 0.0f : -rotation.getY());
            rotation.setZ(axis != 2.0f ? 0.0f : rotation.getZ());
        } else {
            FormatConverter.convertTo1Axis(cube);
        }
    }

    public static void doHackyRotationIfPossible(Cube cube, boolean pre1_21_60) {
        Position3V rotation = cube.getRotation();
        float angle = rotation.getX() + rotation.getY() + rotation.getZ();
        if (!MathUtil.canDoHacky(angle, pre1_21_60) || angle == 0.0f) {
            return;
        }
        if (pre1_21_60) {
            angle = MathUtil.toHackyAngle(angle);
        }
        int axis = cube.getAxisIndex();
        if (angle < 0.0f) {
            angle = 90.0f + angle;
            RotationUtil.roll(cube, -90.0f, axis);
        } else {
            angle -= 90.0f;
            RotationUtil.roll(cube, 90.0f, axis);
        }
        cube.getRotation().set(axis == 0 ? angle : 0.0f, axis == 1 ? angle : 0.0f, axis == 2 ? angle : 0.0f);
    }

    public static void roll(Cube element, float angle, int axis) {
        if (Math.abs(angle) != 90.0f) {
            return;
        }
        RotationUtil.roll(element, axis, angle == (float)(axis == 1 ? -90 : 90) ? 1 : 3, element.getPivot().toArray());
    }

    private static void roll(Cube element, int axis, int steps, float[] origin) {
        origin = ArrayUtil.clone(origin);
        origin = ArrayUtil.javaOffsetArray(origin);
        float[] from = element.getPosition().asJavaPosition(element.getSize()).toArray();
        float[] to = ArrayUtil.add(from, element.getSize().toArray());
        while (steps > 0) {
            --steps;
            float[] cloneTo = ArrayUtil.clone(to);
            switch (axis) {
                case 0: 
                case 1: {
                    to[2] = from[2];
                    from[2] = cloneTo[2];
                    break;
                }
                case 2: {
                    to[1] = from[1];
                    from[1] = cloneTo[1];
                }
            }
            RotationUtil.rotateCoord(from, axis, origin);
            RotationUtil.rotateCoord(to, axis, origin);
            float[] size = ArrayUtil.size(to, from);
            element.getSize().set(new Position3V(size));
            element.getPosition().set(new Position3V(from).asBedrockPosition(element.getSize()));
            switch (axis) {
                case 0: {
                    element.getUvMap().rotate(Direction.WEST, 1);
                    element.getUvMap().rotate(Direction.EAST, 3);
                    element.getUvMap().rotate(Direction.NORTH, 2);
                    element.getUvMap().rotate(Direction.DOWN, 2);
                    break;
                }
                case 1: {
                    element.getUvMap().rotate(Direction.UP, 1);
                    element.getUvMap().rotate(Direction.DOWN, 3);
                    break;
                }
                case 2: {
                    element.getUvMap().rotate(Direction.NORTH, 1);
                    element.getUvMap().rotate(Direction.SOUTH, 3);
                    element.getUvMap().rotate(Direction.UP, 3);
                    element.getUvMap().rotate(Direction.EAST, 3);
                    element.getUvMap().rotate(Direction.WEST, 3);
                    element.getUvMap().rotate(Direction.DOWN, 3);
                }
            }
        }
    }

    private static void rotateCoord(float[] array, int axis, float[] origin) {
        Float a = null;
        int b = -1;
        for (int i = 0; i < array.length; ++i) {
            float s = array[i];
            if (i == axis) continue;
            if (a == null) {
                a = Float.valueOf(s - origin[i]);
                b = i;
                continue;
            }
            array[b] = s - origin[i];
            array[b] = origin[b] - array[b];
            array[i] = origin[i] + a.floatValue();
        }
    }
}

