/*
 * Decompiled with CFR 0.152.
 */
package org.cube.converter.util.math;

import org.cube.converter.util.element.Position3V;

public class MathUtil {
    private MathUtil() {
    }

    public static boolean isValidRotation(Position3V position3V) {
        float addUp = Math.abs(position3V.getX() + position3V.getY() + position3V.getZ());
        return (double)addUp == 22.5 || addUp == 45.0f || addUp == 0.0f;
    }

    public static boolean isValidJavaAngle(float rawAngle, boolean old) {
        return MathUtil.limitAngle(rawAngle, old) == rawAngle;
    }

    public static float limitAngle(float rawAngle, boolean old) {
        return MathUtil.clamp(old ? MathUtil.toHackyAngle(rawAngle) : rawAngle, -45.0f, 45.0f);
    }

    public static float toHackyAngle(float rawAngle) {
        return (float)Math.round(rawAngle / 22.5f) * 22.5f;
    }

    public static boolean canDoHacky(float angle, boolean old) {
        if (old) {
            return (double)Math.abs(angle) % 22.5 != 0.0 || Math.abs(MathUtil.toHackyAngle(angle) - angle) < Math.abs(MathUtil.limitAngle(angle, false) - angle);
        }
        if (MathUtil.isValidJavaAngle(angle, false)) {
            return false;
        }
        float absAngle = Math.abs(angle);
        float newAngle = absAngle > 90.0f ? absAngle - 90.0f : 90.0f - absAngle;
        return MathUtil.isValidJavaAngle(newAngle, false);
    }

    public static float clamp(float num, float min, float max) {
        return num < min ? min : Math.min(num, max);
    }

    public static boolean closeEnoughAbs(float angle, float target) {
        return Math.abs(Math.abs(angle) - Math.abs(target)) < 5.0f;
    }
}

