/*
 * Decompiled with CFR 0.152.
 */
package org.cube.converter.util.minecraft;

import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.cube.converter.util.element.Direction;
import org.cube.converter.util.element.Position2V;
import org.cube.converter.util.element.Position3V;

public class UVUtil {
    public static List<Face> toUvFaces(Position3V size, boolean mirror) {
        Face face = new Face(Direction.DOWN, new Position2V(size.getZ() + size.getX() * 2.0f, 0.0f), new Position2V(-size.getX(), size.getZ()), mirror);
        Face face1 = new Face(Direction.UP, new Position2V(size.getZ() + size.getX(), size.getZ()), new Position2V(-size.getX(), -size.getZ()), mirror);
        return Arrays.asList(mirror ? face1 : face, mirror ? face : face1, new Face(Direction.NORTH, new Position2V(size.getZ(), size.getZ()), new Position2V(size.getX(), size.getY()), mirror), new Face(Direction.SOUTH, new Position2V(size.getZ() * 2.0f + size.getX(), size.getZ()), new Position2V(size.getX(), size.getY()), mirror), new Face(Direction.WEST, new Position2V(size.getZ() + size.getX(), size.getZ()), new Position2V(size.getZ(), size.getY()), mirror), new Face(Direction.EAST, new Position2V(0.0f, size.getZ()), new Position2V(size.getZ(), size.getY()), mirror));
    }

    public static class Face {
        private final Direction direction;
        private Position2V start;
        private Position2V end;

        public Face(Direction direction, Position2V position, Position2V size, boolean mirror) {
            this.direction = direction;
            if (mirror) {
                position = position.add(size.getX(), 0.0f);
                size.setX(-size.getX());
            }
            this.start = position;
            this.end = position.add(size);
        }

        @Generated
        public Direction getDirection() {
            return this.direction;
        }

        @Generated
        public Position2V getStart() {
            return this.start;
        }

        @Generated
        public Position2V getEnd() {
            return this.end;
        }

        @Generated
        public void setStart(Position2V start) {
            this.start = start;
        }

        @Generated
        public void setEnd(Position2V end) {
            this.end = end;
        }
    }
}

