/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.bookshelf.objectholders;

import com.loohp.bookshelf.objectholders.ChunkPosition;
import java.util.Objects;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class BlockPosition {
    private final World world;
    private final int x;
    private final int y;
    private final int z;

    public BlockPosition(World world, int x, int y, int z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPosition(Location location) {
        this(location.getWorld(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public BlockPosition(Block block) {
        this(block.getWorld(), block.getX(), block.getY(), block.getZ());
    }

    public World getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Block getBlock() {
        return this.world.getBlockAt(this.x, this.y, this.z);
    }

    public Location getLocation() {
        return new Location(this.world, (double)this.x, (double)this.y, (double)this.z);
    }

    public ChunkPosition getChunkPosition() {
        return new ChunkPosition(this.world, this.x >> 4, this.z >> 4);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockPosition that = (BlockPosition)o;
        return this.x == that.x && this.y == that.y && this.z == that.z && Objects.equals(this.world, that.world);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.x, this.y, this.z);
    }
}

