/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.bookshelf.objectholders;

import java.util.Objects;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;

public class ChunkPosition {
    private final World world;
    private final int x;
    private final int z;

    public ChunkPosition(World world, int chunkX, int chunkZ) {
        this.world = world;
        this.x = chunkX;
        this.z = chunkZ;
    }

    public ChunkPosition(Location location) {
        this(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    public ChunkPosition(Chunk chunk) {
        this(chunk.getWorld(), chunk.getX(), chunk.getZ());
    }

    public World getWorld() {
        return this.world;
    }

    public int getChunkX() {
        return this.x;
    }

    public int getChunkZ() {
        return this.z;
    }

    public Chunk getChunk() {
        return this.getWorld().getChunkAt(this.x, this.z);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkPosition that = (ChunkPosition)o;
        return this.x == that.x && this.z == that.z && Objects.equals(this.world, that.world);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.x, this.z);
    }
}

