/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.bookshelf.nms;

import com.loohp.bookshelf.nms.NMSWrapper;
import com.loohp.bookshelf.objectholders.BookshelfState;
import java.util.Arrays;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.server.v1_16_R2.ContainerUtil;
import net.minecraft.server.v1_16_R2.Containers;
import net.minecraft.server.v1_16_R2.EntityHuman;
import net.minecraft.server.v1_16_R2.EntityPlayer;
import net.minecraft.server.v1_16_R2.IChatBaseComponent;
import net.minecraft.server.v1_16_R2.ICrafting;
import net.minecraft.server.v1_16_R2.MinecraftKey;
import net.minecraft.server.v1_16_R2.NBTBase;
import net.minecraft.server.v1_16_R2.NBTTagCompound;
import net.minecraft.server.v1_16_R2.NonNullList;
import net.minecraft.server.v1_16_R2.Packet;
import net.minecraft.server.v1_16_R2.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_16_R2.WorldServer;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class V1_16_2
extends NMSWrapper {
    public Component getItemDisplayName(ItemStack itemStack) {
        net.minecraft.server.v1_16_R2.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound nbttagcompound = nmsItemStack.b("display");
        if (nbttagcompound != null && nbttagcompound.hasKeyOfType("Name", 8)) {
            try {
                String displayName = nbttagcompound.getString("Name");
                if (displayName != null) {
                    return GsonComponentSerializer.gson().deserialize((Object)displayName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public BookshelfState getStoredBookshelfState(ItemStack itemStack, int slots) {
        NBTTagCompound blockState;
        net.minecraft.server.v1_16_R2.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound nbt = nmsItemStack.getTag();
        NBTTagCompound nBTTagCompound = blockState = nbt == null ? null : nbt.getCompound("BlockEntityTag");
        if (blockState == null) {
            return null;
        }
        Component customName = null;
        if (blockState.hasKey("CustomName")) {
            customName = GsonComponentSerializer.gson().deserialize((Object)blockState.getString("CustomName"));
        }
        ItemStack[] items = null;
        if (blockState.hasKey("Items")) {
            NonNullList contents = NonNullList.a((int)slots, (Object)CraftItemStack.asNMSCopy((ItemStack)AIR));
            ContainerUtil.b((NBTTagCompound)blockState, (NonNullList)contents);
            items = (ItemStack[])contents.stream().map(i -> V1_16_2.itemOrNull((ItemStack)CraftItemStack.asBukkitCopy((net.minecraft.server.v1_16_R2.ItemStack)i))).toArray(ItemStack[]::new);
        }
        return new BookshelfState(customName, items);
    }

    public ItemStack withStoredBookshelfState(ItemStack itemStack, BookshelfState bookshelfState) {
        net.minecraft.server.v1_16_R2.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound nbt = nmsItemStack.save(new NBTTagCompound());
        NBTTagCompound merge = new NBTTagCompound();
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound blockState = new NBTTagCompound();
        if (bookshelfState.getTitle() != null) {
            blockState.setString("CustomName", (String)GsonComponentSerializer.gson().serialize(bookshelfState.getTitle()));
        }
        if (bookshelfState.getContents() != null) {
            Object[] items = (net.minecraft.server.v1_16_R2.ItemStack[])Arrays.stream(bookshelfState.getContents()).map(i -> CraftItemStack.asNMSCopy((ItemStack)V1_16_2.itemNonNull((ItemStack)i))).toArray(net.minecraft.server.v1_16_R2.ItemStack[]::new);
            ContainerUtil.a((NBTTagCompound)blockState, (NonNullList)NonNullList.a(null, (Object[])items));
        }
        tag.set("BlockEntityTag", (NBTBase)blockState);
        merge.set("tag", (NBTBase)tag);
        nbt.a(merge);
        net.minecraft.server.v1_16_R2.ItemStack modifiedNmsItemStack = net.minecraft.server.v1_16_R2.ItemStack.a((NBTTagCompound)nbt);
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_16_R2.ItemStack)modifiedNmsItemStack);
    }

    public void sendBookshelfWindowOpen(Player player, Inventory inventory, Component title) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        CraftContainer container = new CraftContainer(inventory, (EntityHuman)entityPlayer, entityPlayer.nextContainerCounter());
        Containers windowType = CraftContainer.getNotchInventoryType((Inventory)inventory);
        entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(container.windowId, windowType, (IChatBaseComponent)IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(title)))));
        entityPlayer.activeContainer = container;
        entityPlayer.activeContainer.addSlotListener((ICrafting)entityPlayer);
    }

    public void spawnDustParticle(Location location, int count, Object dustOptions) {
        location.getWorld().spawnParticle(Particle.REDSTONE, location, count, (Object)((Particle.DustOptions)dustOptions));
    }

    public EntityType getHopperMinecartEntityType() {
        return EntityType.MINECART_HOPPER;
    }

    public Key getWorldNamespacedKey(World world) {
        WorldServer nmsWorld = ((CraftWorld)world).getHandle();
        MinecraftKey key = nmsWorld.getTypeKey().a();
        return Key.key((String)key.getNamespace(), (String)key.getKey());
    }
}

