/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.bookshelf.nms;

import com.loohp.bookshelf.nms.NMSWrapper;
import com.loohp.bookshelf.objectholders.BookshelfState;
import java.util.Arrays;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.ItemBlock;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class V1_18_2
extends NMSWrapper {
    public Component getItemDisplayName(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound nbttagcompound = nmsItemStack.b("display");
        if (nbttagcompound != null && nbttagcompound.b("Name", 8)) {
            try {
                String displayName = nbttagcompound.l("Name");
                if (displayName != null) {
                    return GsonComponentSerializer.gson().deserialize((Object)displayName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public BookshelfState getStoredBookshelfState(ItemStack itemStack, int slots) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound blockState = ItemBlock.a((net.minecraft.world.item.ItemStack)nmsItemStack);
        if (blockState == null) {
            return null;
        }
        Component customName = null;
        if (blockState.e("CustomName")) {
            customName = GsonComponentSerializer.gson().deserialize((Object)blockState.l("CustomName"));
        }
        ItemStack[] items = null;
        if (blockState.e("Items")) {
            NonNullList contents = NonNullList.a((int)slots, (Object)CraftItemStack.asNMSCopy((ItemStack)AIR));
            ContainerUtil.b((NBTTagCompound)blockState, (NonNullList)contents);
            items = (ItemStack[])contents.stream().map(i -> V1_18_2.itemOrNull((ItemStack)CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)i))).toArray(ItemStack[]::new);
        }
        return new BookshelfState(customName, items);
    }

    public ItemStack withStoredBookshelfState(ItemStack itemStack, BookshelfState bookshelfState) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound nbt = nmsItemStack.b(new NBTTagCompound());
        NBTTagCompound merge = new NBTTagCompound();
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound blockState = new NBTTagCompound();
        if (bookshelfState.getTitle() != null) {
            blockState.a("CustomName", (String)GsonComponentSerializer.gson().serialize(bookshelfState.getTitle()));
        }
        if (bookshelfState.getContents() != null) {
            Object[] items = (net.minecraft.world.item.ItemStack[])Arrays.stream(bookshelfState.getContents()).map(i -> CraftItemStack.asNMSCopy((ItemStack)V1_18_2.itemNonNull((ItemStack)i))).toArray(net.minecraft.world.item.ItemStack[]::new);
            ContainerUtil.a((NBTTagCompound)blockState, (NonNullList)NonNullList.a(null, (Object[])items));
        }
        tag.a("BlockEntityTag", (NBTBase)blockState);
        merge.a("tag", (NBTBase)tag);
        nbt.a(merge);
        net.minecraft.world.item.ItemStack modifiedNmsItemStack = net.minecraft.world.item.ItemStack.a((NBTTagCompound)nbt);
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)modifiedNmsItemStack);
    }

    public void sendBookshelfWindowOpen(Player player, Inventory inventory, Component title) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        CraftContainer container = new CraftContainer(inventory, (EntityHuman)entityPlayer, entityPlayer.nextContainerCounter());
        Containers windowType = CraftContainer.getNotchInventoryType((Inventory)inventory);
        entityPlayer.b.a((Packet)new PacketPlayOutOpenWindow(container.j, windowType, CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(title)))));
        entityPlayer.bV = container;
        entityPlayer.a((Container)container);
    }

    public void spawnDustParticle(Location location, int count, Object dustOptions) {
        location.getWorld().spawnParticle(Particle.REDSTONE, location, count, (Object)((Particle.DustOptions)dustOptions));
    }

    public EntityType getHopperMinecartEntityType() {
        return EntityType.MINECART_HOPPER;
    }

    public Key getWorldNamespacedKey(World world) {
        NamespacedKey key = world.getKey();
        return Key.key((String)key.getNamespace(), (String)key.getKey());
    }
}

