/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.bookshelf.nms;

import com.loohp.bookshelf.nms.NMSWrapper;
import com.loohp.bookshelf.objectholders.BookshelfState;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.item.component.ItemContainerContents;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_20_R4.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_20_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_20_R4.util.CraftChatMessage;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class V1_20_5
extends NMSWrapper {
    public Component getItemDisplayName(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        IChatBaseComponent displayName = (IChatBaseComponent)nmsItemStack.a(DataComponents.g);
        return displayName == null ? null : GsonComponentSerializer.gson().deserialize((Object)CraftChatMessage.toJSON((IChatBaseComponent)displayName));
    }

    public BookshelfState getStoredBookshelfState(ItemStack itemStack, int slots) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        ItemContainerContents contents = (ItemContainerContents)nmsItemStack.a(DataComponents.aa);
        Component title = this.getItemDisplayName(itemStack);
        if (contents == null) {
            return title == null ? null : new BookshelfState(title, null);
        }
        ItemStack[] items = (ItemStack[])contents.b().map(i -> V1_20_5.itemOrNull((ItemStack)CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)i))).toArray(ItemStack[]::new);
        return new BookshelfState(this.getItemDisplayName(itemStack), items);
    }

    public ItemStack withStoredBookshelfState(ItemStack itemStack, BookshelfState bookshelfState) {
        net.minecraft.world.item.ItemStack nmsItemStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        DataComponentPatch.a builder = DataComponentPatch.a();
        if (bookshelfState.getTitle() != null) {
            builder.a(DataComponents.g, (Object)CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(bookshelfState.getTitle()))));
        }
        if (bookshelfState.getContents() != null) {
            List items = Arrays.stream(bookshelfState.getContents()).map(i -> CraftItemStack.asNMSCopy((ItemStack)V1_20_5.itemNonNull((ItemStack)i))).collect(Collectors.toList());
            ItemContainerContents contents = ItemContainerContents.a(items);
            builder.a(DataComponents.aa, (Object)contents);
        }
        nmsItemStack.a(builder.a());
        return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)nmsItemStack);
    }

    public void sendBookshelfWindowOpen(Player player, Inventory inventory, Component title) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        CraftContainer container = new CraftContainer(inventory, (EntityHuman)entityPlayer, entityPlayer.nextContainerCounter());
        Containers windowType = CraftContainer.getNotchInventoryType((Inventory)inventory);
        entityPlayer.c.b((Packet)new PacketPlayOutOpenWindow(container.j, windowType, CraftChatMessage.fromJSON((String)((String)GsonComponentSerializer.gson().serialize(title)))));
        entityPlayer.cb = container;
        entityPlayer.a((Container)container);
    }

    public void spawnDustParticle(Location location, int count, Object dustOptions) {
        location.getWorld().spawnParticle(Particle.DUST, location, count, (Object)((Particle.DustOptions)dustOptions));
    }

    public EntityType getHopperMinecartEntityType() {
        return EntityType.HOPPER_MINECART;
    }

    public Key getWorldNamespacedKey(World world) {
        NamespacedKey key = world.getKey();
        return Key.key((String)key.getNamespace(), (String)key.getKey());
    }
}

