/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.nms;

import com.comphenix.protocol.events.PacketContainer;
import com.loohp.holomobhealth.holders.IHoloMobArmorStand;
import com.loohp.holomobhealth.nms.NMSWrapper;
import com.loohp.holomobhealth.utils.BoundingBox;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.server.v1_16_R2.AxisAlignedBB;
import net.minecraft.server.v1_16_R2.DataWatcher;
import net.minecraft.server.v1_16_R2.DataWatcherObject;
import net.minecraft.server.v1_16_R2.EntityArmorStand;
import net.minecraft.server.v1_16_R2.EntityTropicalFish;
import net.minecraft.server.v1_16_R2.EntityTypes;
import net.minecraft.server.v1_16_R2.IChatBaseComponent;
import net.minecraft.server.v1_16_R2.IRegistry;
import net.minecraft.server.v1_16_R2.MathHelper;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R2.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_16_R2.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_16_R2.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_16_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_16_R2.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class V1_16_2
extends NMSWrapper {
    private final Field[] entityMetadataPacketFields;
    private final Field entityCountField;
    private final Field dataWatcherByteField;
    private final Field dataWatcherCustomNameField;
    private final Field dataWatcherCustomNameVisibleField;
    private final Field dataWatcherSilentField;
    private final Field dataWatcherNoGravityField;
    private final Field[] spawnEntityLivingPacketFields;
    private final Field[] entityTeleportPacketFields;

    public V1_16_2() {
        try {
            this.entityMetadataPacketFields = PacketPlayOutEntityMetadata.class.getDeclaredFields();
            this.entityCountField = net.minecraft.server.v1_16_R2.Entity.class.getDeclaredField("entityCount");
            this.dataWatcherByteField = net.minecraft.server.v1_16_R2.Entity.class.getDeclaredField("S");
            this.dataWatcherCustomNameField = net.minecraft.server.v1_16_R2.Entity.class.getDeclaredField("aq");
            this.dataWatcherCustomNameVisibleField = net.minecraft.server.v1_16_R2.Entity.class.getDeclaredField("ar");
            this.dataWatcherSilentField = net.minecraft.server.v1_16_R2.Entity.class.getDeclaredField("as");
            this.dataWatcherNoGravityField = net.minecraft.server.v1_16_R2.Entity.class.getDeclaredField("at");
            this.spawnEntityLivingPacketFields = PacketPlayOutSpawnEntityLiving.class.getDeclaredFields();
            this.entityTeleportPacketFields = PacketPlayOutEntityTeleport.class.getDeclaredFields();
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public PacketContainer[] createEntityDestroyPacket(int ... entityIds) {
        return new PacketContainer[]{V1_16_2.p((Object)new PacketPlayOutEntityDestroy(entityIds))};
    }

    public PacketContainer createEntityMetadataPacket(int entityId, List<?> dataWatchers) {
        try {
            PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata();
            this.entityMetadataPacketFields[0].setAccessible(true);
            this.entityMetadataPacketFields[0].setInt(packet, entityId);
            this.entityMetadataPacketFields[1].setAccessible(true);
            this.entityMetadataPacketFields[1].set(packet, dataWatchers);
            return V1_16_2.p((Object)packet);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public PacketContainer createEntityTeleportPacket(int entityId, Location location) {
        try {
            PacketPlayOutEntityTeleport packet = new PacketPlayOutEntityTeleport();
            this.entityTeleportPacketFields[0].setAccessible(true);
            this.entityTeleportPacketFields[1].setAccessible(true);
            this.entityTeleportPacketFields[2].setAccessible(true);
            this.entityTeleportPacketFields[3].setAccessible(true);
            this.entityTeleportPacketFields[4].setAccessible(true);
            this.entityTeleportPacketFields[5].setAccessible(true);
            this.entityTeleportPacketFields[6].setAccessible(true);
            this.entityTeleportPacketFields[0].setInt(packet, entityId);
            this.entityTeleportPacketFields[1].setDouble(packet, location.getX());
            this.entityTeleportPacketFields[2].setDouble(packet, location.getY());
            this.entityTeleportPacketFields[3].setDouble(packet, location.getZ());
            this.entityTeleportPacketFields[4].setByte(packet, (byte)(location.getYaw() * 256.0f / 360.0f));
            this.entityTeleportPacketFields[5].setByte(packet, (byte)(location.getPitch() * 256.0f / 360.0f));
            this.entityTeleportPacketFields[6].setBoolean(packet, false);
            return V1_16_2.p((Object)packet);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public BoundingBox getBoundingBox(Entity entity) {
        org.bukkit.util.BoundingBox box = entity.getBoundingBox();
        return BoundingBox.of((Vector)box.getMin(), (Vector)box.getMax());
    }

    public Component getEntityCustomName(Entity entity) {
        IChatBaseComponent customName = ((CraftEntity)entity).getHandle().getCustomName();
        return GsonComponentSerializer.gson().deserialize((Object)CraftChatMessage.toJSON((IChatBaseComponent)customName));
    }

    public String getEntityTranslationKey(Entity entity) {
        EntityTypes type = (EntityTypes)EntityTypes.a((String)entity.getType().getName()).orElseThrow(() -> new RuntimeException());
        return type.f();
    }

    public Future<Integer> getNextEntityId() {
        try {
            this.entityCountField.setAccessible(true);
            AtomicInteger counter = (AtomicInteger)this.entityCountField.get(null);
            return CompletableFuture.completedFuture(counter.incrementAndGet());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Entity> getPassengers(Entity entity) {
        return entity.getPassengers();
    }

    public int getTropicalFishVariant(Entity entity) {
        net.minecraft.server.v1_16_R2.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        EntityTropicalFish fish = (EntityTropicalFish)nmsEntity;
        return fish.getVariant();
    }

    public UUID getEntityUUIDFromID(World world, int id) {
        try {
            WorldServer worldServer = ((CraftWorld)world).getHandle();
            net.minecraft.server.v1_16_R2.Entity entity = (net.minecraft.server.v1_16_R2.Entity)worldServer.entitiesById.get(id);
            return entity == null ? null : entity.getUniqueID();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Entity getEntityFromUUID(UUID uuid) {
        return Bukkit.getEntity((UUID)uuid);
    }

    public double getEntityHeight(Entity entity) {
        net.minecraft.server.v1_16_R2.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB axisAlignedBB = nmsEntity.getBoundingBox();
        double minY = axisAlignedBB.minY;
        double maxY = axisAlignedBB.maxY;
        return maxY - minY;
    }

    public double getEntityWidth(Entity entity) {
        net.minecraft.server.v1_16_R2.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        AxisAlignedBB axisAlignedBB = nmsEntity.getBoundingBox();
        double minX = axisAlignedBB.minX;
        double maxX = axisAlignedBB.maxX;
        return maxX - minX;
    }

    public PacketContainer createUpdateEntityPacket(Entity entity) {
        try {
            ArrayList<DataWatcher.Item> dataWatcher = new ArrayList<DataWatcher.Item>();
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            net.minecraft.server.v1_16_R2.Entity nmsEntity = ((CraftEntity)entity).getHandle();
            DataWatcher watcher = nmsEntity.getDataWatcher();
            Optional name = (Optional)watcher.get((DataWatcherObject)this.dataWatcherCustomNameField.get(null));
            boolean visible = (Boolean)watcher.get((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), (Object)name));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)visible));
            return this.createEntityMetadataPacket(entity.getEntityId(), dataWatcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PacketContainer createUpdateEntityMetadataPacket(Entity entity, Component entityNameComponent, boolean visible) {
        try {
            ArrayList<DataWatcher.Item> dataWatcher = new ArrayList<DataWatcher.Item>();
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.ofNullable(IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), name));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)visible));
            return this.createEntityMetadataPacket(entity.getEntityId(), dataWatcher);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<?> buildDataWatchers(IHoloMobArmorStand entity, Component entityNameComponent, boolean visible) {
        try {
            ArrayList<DataWatcher.Item> dataWatcher = new ArrayList<DataWatcher.Item>();
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherNoGravityField.setAccessible(true);
            byte bitmask = 32;
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherByteField.get(null), (Object)bitmask));
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.ofNullable(IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), name));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)visible));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherNoGravityField.get(null), (Object)true));
            byte standbitmask = 17;
            dataWatcher.add(new DataWatcher.Item(EntityArmorStand.b, (Object)standbitmask));
            return dataWatcher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PacketContainer[] createArmorStandSpawnPackets(IHoloMobArmorStand entity, Component component, boolean visible) {
        try {
            EntityTypes type = (EntityTypes)EntityTypes.a((String)entity.getType().getName()).orElseThrow(() -> new RuntimeException());
            PacketPlayOutSpawnEntityLiving packet1 = new PacketPlayOutSpawnEntityLiving();
            this.spawnEntityLivingPacketFields[0].setAccessible(true);
            this.spawnEntityLivingPacketFields[1].setAccessible(true);
            this.spawnEntityLivingPacketFields[2].setAccessible(true);
            this.spawnEntityLivingPacketFields[3].setAccessible(true);
            this.spawnEntityLivingPacketFields[4].setAccessible(true);
            this.spawnEntityLivingPacketFields[5].setAccessible(true);
            this.spawnEntityLivingPacketFields[6].setAccessible(true);
            this.spawnEntityLivingPacketFields[7].setAccessible(true);
            this.spawnEntityLivingPacketFields[8].setAccessible(true);
            this.spawnEntityLivingPacketFields[9].setAccessible(true);
            this.spawnEntityLivingPacketFields[10].setAccessible(true);
            this.spawnEntityLivingPacketFields[11].setAccessible(true);
            this.spawnEntityLivingPacketFields[0].setInt(packet1, entity.getEntityId());
            this.spawnEntityLivingPacketFields[1].set(packet1, entity.getUniqueId());
            this.spawnEntityLivingPacketFields[2].setInt(packet1, IRegistry.ENTITY_TYPE.a((Object)type));
            this.spawnEntityLivingPacketFields[3].setDouble(packet1, entity.getLocation().getX());
            this.spawnEntityLivingPacketFields[4].setDouble(packet1, entity.getLocation().getY());
            this.spawnEntityLivingPacketFields[5].setDouble(packet1, entity.getLocation().getZ());
            this.spawnEntityLivingPacketFields[6].setInt(packet1, 0);
            this.spawnEntityLivingPacketFields[7].setInt(packet1, 0);
            this.spawnEntityLivingPacketFields[8].setInt(packet1, 0);
            this.spawnEntityLivingPacketFields[9].setByte(packet1, (byte)(entity.getLocation().getYaw() * 256.0f / 360.0f));
            this.spawnEntityLivingPacketFields[10].setByte(packet1, (byte)(entity.getLocation().getPitch() * 256.0f / 360.0f));
            this.spawnEntityLivingPacketFields[11].setByte(packet1, (byte)(entity.getLocation().getYaw() * 256.0f / 360.0f));
            List<?> dataWatchers = this.buildDataWatchers(entity, component, visible);
            PacketContainer packet2 = this.createEntityMetadataPacket(entity.getEntityId(), dataWatchers);
            return new PacketContainer[]{V1_16_2.p((Object)packet1), packet2};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PacketContainer[] createUpdateArmorStandPackets(IHoloMobArmorStand entity, Component component, boolean visible) {
        List<?> dataWatchers = this.buildDataWatchers(entity, component, visible);
        PacketContainer packet1 = this.createEntityMetadataPacket(entity.getEntityId(), dataWatchers);
        PacketContainer packet2 = this.createEntityTeleportPacket(entity.getEntityId(), entity.getLocation());
        return new PacketContainer[]{packet1, packet2};
    }

    public PacketContainer[] createUpdateArmorStandLocationPackets(IHoloMobArmorStand entity) {
        return new PacketContainer[]{this.createEntityTeleportPacket(entity.getEntityId(), entity.getLocation())};
    }

    public PacketContainer[] createSpawnDamageIndicatorPackets(int entityId, UUID uuid, Component entityNameComponent, Location location, Vector velocity, boolean gravity) {
        try {
            EntityTypes type = EntityTypes.ARMOR_STAND;
            PacketPlayOutSpawnEntityLiving packet1 = new PacketPlayOutSpawnEntityLiving();
            this.spawnEntityLivingPacketFields[0].setAccessible(true);
            this.spawnEntityLivingPacketFields[1].setAccessible(true);
            this.spawnEntityLivingPacketFields[2].setAccessible(true);
            this.spawnEntityLivingPacketFields[3].setAccessible(true);
            this.spawnEntityLivingPacketFields[4].setAccessible(true);
            this.spawnEntityLivingPacketFields[5].setAccessible(true);
            this.spawnEntityLivingPacketFields[6].setAccessible(true);
            this.spawnEntityLivingPacketFields[7].setAccessible(true);
            this.spawnEntityLivingPacketFields[8].setAccessible(true);
            this.spawnEntityLivingPacketFields[9].setAccessible(true);
            this.spawnEntityLivingPacketFields[10].setAccessible(true);
            this.spawnEntityLivingPacketFields[11].setAccessible(true);
            this.spawnEntityLivingPacketFields[0].setInt(packet1, entityId);
            this.spawnEntityLivingPacketFields[1].set(packet1, uuid);
            this.spawnEntityLivingPacketFields[2].setInt(packet1, IRegistry.ENTITY_TYPE.a((Object)type));
            this.spawnEntityLivingPacketFields[3].setDouble(packet1, location.getX());
            this.spawnEntityLivingPacketFields[4].setDouble(packet1, location.getY());
            this.spawnEntityLivingPacketFields[5].setDouble(packet1, location.getZ());
            this.spawnEntityLivingPacketFields[6].setInt(packet1, (int)(MathHelper.a((double)velocity.getX(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[7].setInt(packet1, (int)(MathHelper.a((double)velocity.getY(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[8].setInt(packet1, (int)(MathHelper.a((double)velocity.getZ(), (double)-3.9, (double)3.9) * 8000.0));
            this.spawnEntityLivingPacketFields[9].setByte(packet1, (byte)0);
            this.spawnEntityLivingPacketFields[10].setByte(packet1, (byte)0);
            this.spawnEntityLivingPacketFields[11].setByte(packet1, (byte)0);
            ArrayList<DataWatcher.Item> dataWatcher = new ArrayList<DataWatcher.Item>();
            this.dataWatcherByteField.setAccessible(true);
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            this.dataWatcherSilentField.setAccessible(true);
            this.dataWatcherNoGravityField.setAccessible(true);
            byte bitmask = 32;
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherByteField.get(null), (Object)bitmask));
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.ofNullable(IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), name));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)true));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherSilentField.get(null), (Object)true));
            dataWatcher.add(new DataWatcher.Item((DataWatcherObject)this.dataWatcherNoGravityField.get(null), (Object)(!gravity ? 1 : 0)));
            byte standBitmask = 25;
            dataWatcher.add(new DataWatcher.Item(EntityArmorStand.b, (Object)standBitmask));
            PacketContainer packet2 = this.createEntityMetadataPacket(entityId, dataWatcher);
            return new PacketContainer[]{V1_16_2.p((Object)packet1), packet2};
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<DataWatcher.Item<?>> readDataWatchersFromMetadataPacket(PacketContainer packet) {
        try {
            PacketPlayOutEntityMetadata nmsPacket = (PacketPlayOutEntityMetadata)packet.getHandle();
            this.entityMetadataPacketFields[1].setAccessible(true);
            return (List)this.entityMetadataPacketFields[1].get(nmsPacket);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void addOrReplaceDataWatcher(List<DataWatcher.Item<?>> dataWatcher, DataWatcher.Item<T> newWatcher) {
        for (int i = 0; i < dataWatcher.size(); ++i) {
            DataWatcher.Item<?> watcher = dataWatcher.get(i);
            if (newWatcher.a().a() != watcher.a().a() || !newWatcher.b().equals(watcher.b())) continue;
            dataWatcher.set(i, newWatcher);
            return;
        }
        dataWatcher.add(newWatcher);
    }

    public void modifyDataWatchers(List<?> dataWatchers, Component entityNameComponent, boolean visible) {
        try {
            List<DataWatcher.Item<?>> dataWatcher = dataWatchers;
            this.dataWatcherCustomNameField.setAccessible(true);
            this.dataWatcherCustomNameVisibleField.setAccessible(true);
            Optional name = entityNameComponent == null ? Optional.empty() : Optional.ofNullable(IChatBaseComponent.ChatSerializer.a((String)((String)GsonComponentSerializer.gson().serialize(entityNameComponent))));
            this.addOrReplaceDataWatcher(dataWatcher, new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameField.get(null), name));
            this.addOrReplaceDataWatcher(dataWatcher, new DataWatcher.Item((DataWatcherObject)this.dataWatcherCustomNameVisibleField.get(null), (Object)visible));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PacketContainer createModifiedMetadataPacket(PacketContainer packet, List<?> dataWatchers) {
        try {
            PacketPlayOutEntityMetadata nmsPacket = (PacketPlayOutEntityMetadata)packet.getHandle();
            this.entityMetadataPacketFields[0].setAccessible(true);
            int id = this.entityMetadataPacketFields[0].getInt(nmsPacket);
            return this.createEntityMetadataPacket(id, dataWatchers);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

