/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration;

import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.RootConfigurationSection;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Yaml;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.utils.FixerUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class YamlConfiguration
extends RootConfigurationSection {
    private File file;
    private boolean guessIndentation;
    private boolean fixValues;

    public YamlConfiguration(File file, boolean guessIndentation, boolean fixValues) throws IOException {
        super(Yaml.createYamlInput(fixValues ? FixerUtils.fixYaml(file) : file, StandardCharsets.UTF_8, guessIndentation).readYamlMapping());
        this.file = file;
        this.guessIndentation = guessIndentation;
        this.fixValues = fixValues;
    }

    public YamlConfiguration(File file, boolean guessIndentation) throws IOException {
        this(file, true, true);
    }

    public YamlConfiguration(File file) throws IOException {
        this(file, true);
    }

    public YamlConfiguration(InputStream inputStream, boolean guessIndentation, boolean fixValues) throws IOException {
        super(Yaml.createYamlInput(fixValues ? FixerUtils.fixYaml(inputStream) : inputStream, StandardCharsets.UTF_8, guessIndentation).readYamlMapping());
        this.file = null;
        this.guessIndentation = guessIndentation;
        this.fixValues = fixValues;
    }

    public YamlConfiguration(InputStream inputStream, boolean guessIndentation) throws IOException {
        this(inputStream, true, true);
    }

    public YamlConfiguration(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    @Override
    public boolean fromExistingYaml() {
        return true;
    }

    public boolean hasFile() {
        return this.file != null;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String saveToString() {
        StringWriter writer = new StringWriter();
        try {
            this.save(writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public void save(File file) {
        try {
            this.save(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        if (!this.hasFile()) {
            throw new UncheckedIOException(new FileNotFoundException("This YamlConfiguration is not created with a file"));
        }
        this.save(this.file);
    }

    public void save(OutputStream output) {
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));){
            this.save(pw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save(Writer writer) throws IOException {
        Yaml.createYamlPrinter(writer).print(this.currentMapping);
    }

    public void reload() {
        try {
            this.currentMapping = Yaml.createYamlInput(this.file, StandardCharsets.UTF_8, this.guessIndentation).readYamlMapping();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

