/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml;

import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.BaseFoldedScalar;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.BaseScalar;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Comment;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.EmptyYamlMapping;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.EmptyYamlSequence;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ReadLiteralBlockScalar;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ReadSingleLineSequence;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.RtYamlScalarBuilder;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Scalar;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.ScalarComment;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlMapping;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlNode;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlPrinter;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlSequence;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlStream;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;

final class RtYamlPrinter
implements YamlPrinter {
    private final Writer writer;

    RtYamlPrinter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public void print(YamlNode node) throws IOException {
        try {
            if (node instanceof Scalar) {
                this.writer.append("---").append(System.lineSeparator());
                this.printPossibleComment(node, "");
                this.printScalar((Scalar)node, 0);
                this.writer.append(System.lineSeparator()).append("...");
            } else if (node instanceof YamlSequence) {
                boolean documentComment = this.printPossibleComment(node, "");
                if (documentComment) {
                    this.writer.append("---").append(System.lineSeparator());
                }
                this.printSequence((YamlSequence)node, 0);
            } else if (node instanceof YamlMapping) {
                boolean documentComment = this.printPossibleComment(node, "");
                if (documentComment) {
                    this.writer.append("---").append(System.lineSeparator());
                }
                this.printMapping((YamlMapping)node, 0);
            } else if (node instanceof YamlStream) {
                this.printStream((YamlStream)node, 0);
            }
        }
        finally {
            this.writer.close();
        }
    }

    private void printStream(YamlStream stream, int indentation) throws IOException {
        String newLine = System.lineSeparator();
        StringBuilder indent = new StringBuilder();
        for (int spaces = indentation; spaces > 0; --spaces) {
            indent.append(" ");
        }
        Iterator<YamlNode> valuesIt = stream.values().iterator();
        while (valuesIt.hasNext()) {
            YamlNode document = valuesIt.next();
            this.writer.append(indent).append("---");
            this.printNode(document, true, indentation + 2);
            if (!valuesIt.hasNext()) continue;
            this.writer.append(newLine);
        }
    }

    private void printMapping(YamlMapping mapping, int indentation) throws IOException {
        String newLine = System.lineSeparator();
        StringBuilder alignment = new StringBuilder();
        for (int spaces = indentation; spaces > 0; --spaces) {
            alignment.append(" ");
        }
        Iterator<YamlNode> keysIt = mapping.keys().iterator();
        while (keysIt.hasNext()) {
            YamlNode key = keysIt.next();
            YamlNode value = mapping.value(key);
            this.printPossibleComment(value, alignment.toString());
            this.writer.append(alignment);
            if (key instanceof Scalar) {
                this.writer.append(this.indent(new Escaped((Scalar)key).value(), 0));
                this.writer.append(":");
            } else {
                this.writer.append("?");
                this.printNode(key, true, indentation + 2);
                this.writer.append(newLine).append(alignment).append(":");
            }
            if (value instanceof Scalar) {
                this.printNode(value, false, indentation);
            } else if (value instanceof ReadSingleLineSequence) {
                this.writer.append(" [");
                this.printNode(value, false, false, 0);
                this.writer.append("]");
            } else {
                this.printNode(value, true, indentation + 2);
            }
            if (!keysIt.hasNext()) continue;
            this.writer.append(newLine);
        }
    }

    private void printSequence(YamlSequence sequence, int indentation) throws IOException {
        String newLine = System.lineSeparator();
        StringBuilder alignment = new StringBuilder();
        for (int spaces = indentation; spaces > 0; --spaces) {
            alignment.append(" ");
        }
        Iterator<YamlNode> valuesIt = sequence.values().iterator();
        while (valuesIt.hasNext()) {
            YamlNode node = valuesIt.next();
            this.printPossibleComment(node, alignment.toString());
            if (node instanceof ReadSingleLineSequence.ReadSingleLineSequencePlainLiteralScalar) {
                this.printNode(node, false, false, 0);
                if (!valuesIt.hasNext()) continue;
                this.writer.append(", ");
                continue;
            }
            this.writer.append(alignment).append("-");
            if (node instanceof Scalar) {
                this.printNode(node, false, 0);
            } else if (node instanceof ReadSingleLineSequence) {
                this.writer.append(" [");
                this.printNode(node, false, false, 0);
                this.writer.append("]");
            } else {
                this.printNode(node, true, indentation + 2);
            }
            if (!valuesIt.hasNext()) continue;
            this.writer.append(newLine);
        }
    }

    private void printScalar(Scalar scalar, int indentation) throws IOException {
        if (scalar instanceof BaseFoldedScalar) {
            BaseFoldedScalar foldedScalar = (BaseFoldedScalar)scalar;
            this.writer.append(">");
            if (!scalar.comment().value().isEmpty()) {
                this.writer.append(" # ").append(scalar.comment().value());
            }
            this.writer.append(System.lineSeparator());
            List<String> unfolded = foldedScalar.unfolded();
            for (int idx = 0; idx < unfolded.size(); ++idx) {
                this.writer.append(this.indent(unfolded.get(idx).trim(), indentation + 2));
                if (idx >= unfolded.size() - 1) continue;
                this.writer.append(System.lineSeparator());
            }
        } else if (scalar instanceof RtYamlScalarBuilder.BuiltLiteralBlockScalar || scalar instanceof ReadLiteralBlockScalar) {
            this.writer.append("|");
            if (!scalar.comment().value().isEmpty()) {
                this.writer.append(" # ").append(scalar.comment().value());
            }
            this.writer.append(System.lineSeparator()).append(this.indent(scalar.value(), indentation + 2));
        } else if (scalar instanceof ReadSingleLineSequence.ReadSingleLineSequencePlainLiteralScalar) {
            this.writer.append(new Escaped(scalar).value());
        } else {
            ScalarComment scalarComment;
            Comment comment = scalar.comment();
            this.writer.append(this.indent(new Escaped(scalar).value(), 0));
            if (comment instanceof ScalarComment && !(scalarComment = (ScalarComment)comment).inline().value().isEmpty()) {
                this.writer.append(" # ").append(scalarComment.inline().value());
            }
        }
    }

    private void printNode(YamlNode node, boolean onNewLine, int indentation) throws IOException {
        this.printNode(node, onNewLine, true, indentation);
    }

    private void printNode(YamlNode node, boolean onNewLine, boolean prependSpace, int indentation) throws IOException {
        if (node == null || node.isEmpty()) {
            if (node instanceof EmptyYamlSequence) {
                this.writer.append(" ").append("[]");
            } else if (node instanceof EmptyYamlMapping) {
                this.writer.append(" ").append("{}");
            } else if (node == null) {
                this.writer.append(" ").append("null");
            } else {
                this.writer.append(" ").append("\"\"");
            }
        } else {
            if (onNewLine) {
                this.writer.append(System.lineSeparator());
            } else if (prependSpace) {
                this.writer.append(" ");
            }
            if (node instanceof Scalar) {
                this.printScalar((Scalar)node, indentation);
            } else if (node instanceof YamlSequence) {
                this.printSequence((YamlSequence)node, indentation);
            } else if (node instanceof YamlMapping) {
                this.printMapping((YamlMapping)node, indentation);
            } else if (node instanceof YamlStream) {
                this.printStream((YamlStream)node, indentation);
            }
        }
    }

    private boolean printPossibleComment(YamlNode node, String alignment) throws IOException {
        Comment tmpComment;
        String com;
        boolean printed = false;
        if (node != null && node.comment() != null && (com = (tmpComment = node.comment() instanceof ScalarComment ? ((ScalarComment)node.comment()).above() : node.comment()).value()).trim().length() != 0) {
            String[] lines;
            for (String line : lines = com.split(System.lineSeparator())) {
                this.writer.append(alignment).append("# ").append(line).append(System.lineSeparator());
            }
            printed = true;
        }
        return printed;
    }

    private String indent(String value, int indentation) {
        StringBuilder alignment = new StringBuilder();
        for (int spaces = indentation; spaces > 0; --spaces) {
            alignment.append(" ");
        }
        String[] lines = value.split(System.lineSeparator());
        StringBuilder printed = new StringBuilder();
        for (int idx = 0; idx < lines.length; ++idx) {
            printed.append((CharSequence)alignment);
            printed.append(lines[idx]);
            if (idx >= lines.length - 1) continue;
            printed.append(System.lineSeparator());
        }
        return printed.toString();
    }

    static class Escaped
    extends BaseScalar {
        private final Scalar original;

        Escaped(Scalar original) {
            this.original = original;
        }

        @Override
        public String value() {
            boolean quoted;
            String value;
            String escaped = value = this.original.value();
            boolean bl = quoted = value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"");
            if (!quoted && value.matches(".*[\\\\?\\-#:>|$%&{}\\[\\]]+.*|[ ]+") && !value.matches("-?[0-9]+(?:\\.[0-9]+)?")) {
                escaped = value.contains("\"") ? "'" + value + "'" : "\"" + value + "\"";
            }
            return escaped;
        }

        @Override
        public Comment comment() {
            return this.original.comment();
        }
    }
}

