/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.extensions;

import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.BaseYamlMapping;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Comment;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.Yaml;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlMapping;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlMappingBuilder;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlNode;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlSequence;
import com.loohp.holomobhealth.libs.com.loohp.yamlconfiguration.libs.com.amihaiemil.eoyaml.YamlSequenceBuilder;
import java.util.Set;
import java.util.function.Supplier;

public final class MergedYamlMapping
extends BaseYamlMapping {
    private YamlMapping merged;

    public MergedYamlMapping(YamlMapping original, YamlMapping changed) {
        this(original, changed, false);
    }

    public MergedYamlMapping(YamlMapping original, Supplier<YamlMapping> changed) {
        this(original, changed, false);
    }

    public MergedYamlMapping(YamlMapping original, Supplier<YamlMapping> changed, boolean overrideConflicts) {
        this(original, changed.get(), overrideConflicts);
    }

    public MergedYamlMapping(YamlMapping original, YamlMapping changed, boolean overrideConflicts) {
        if (original == null && changed == null) {
            throw new IllegalArgumentException("Both mappings cannot be null!");
        }
        this.merged = this.merge(original, changed, overrideConflicts);
    }

    @Override
    public Set<YamlNode> keys() {
        return this.merged.keys();
    }

    @Override
    public YamlNode value(YamlNode key) {
        return this.merged.value(key);
    }

    @Override
    public Comment comment() {
        return this.merged.comment();
    }

    private YamlMapping merge(YamlMapping original, YamlMapping changed, boolean overrideConflicts) {
        YamlMapping merged = original == null || original.keys().isEmpty() ? changed : (changed == null || changed.keys().isEmpty() ? original : this.recursiveMerge(original, changed, overrideConflicts));
        return merged;
    }

    private YamlMapping recursiveMerge(YamlMapping original, YamlMapping changed, boolean overrideConflicts) {
        YamlMappingBuilder originalBuilder = this.yamlMappingBuilderFrom(original);
        Set<YamlNode> changedKeys = changed.keys();
        for (YamlNode key : changedKeys) {
            YamlNode originalValue = original.value(key);
            YamlNode changedValue = changed.value(key);
            if (changedValue instanceof YamlMapping && originalValue instanceof YamlMapping) {
                originalBuilder = originalBuilder.add(key, (YamlNode)this.recursiveMerge((YamlMapping)originalValue, (YamlMapping)changedValue, overrideConflicts));
                continue;
            }
            if (overrideConflicts && changedValue instanceof YamlSequence && originalValue instanceof YamlSequence) {
                YamlSequence originalSeq = (YamlSequence)originalValue;
                YamlSequence changedSeq = (YamlSequence)changedValue;
                YamlSequenceBuilder originalSeqBuilder = this.yamlSequenceBuilderFrom(originalSeq);
                for (YamlNode node : changedSeq.values()) {
                    if (originalSeq.values().contains(node)) continue;
                    originalSeqBuilder = originalSeqBuilder.add(node);
                }
                Comment newComment = !changedSeq.comment().value().isEmpty() ? changedSeq.comment() : originalSeq.comment();
                originalBuilder = originalBuilder.add(key, (YamlNode)originalSeqBuilder.build(newComment.value()));
                continue;
            }
            YamlNode newValue = originalValue != null ? (overrideConflicts ? changedValue : originalValue) : changedValue;
            originalBuilder = originalBuilder.add(key, newValue);
        }
        Comment newComment = overrideConflicts && !changed.comment().value().isEmpty() ? changed.comment() : original.comment();
        return originalBuilder.build(newComment.value());
    }

    private YamlSequenceBuilder yamlSequenceBuilderFrom(YamlSequence source) {
        YamlSequenceBuilder builder = Yaml.createYamlSequenceBuilder();
        for (YamlNode node : source.values()) {
            builder = builder.add(node);
        }
        return builder;
    }

    private YamlMappingBuilder yamlMappingBuilderFrom(YamlMapping source) {
        YamlMappingBuilder builder = Yaml.createYamlMappingBuilder();
        for (YamlNode key : source.keys()) {
            builder = builder.add(key, source.value(key));
        }
        return builder;
    }
}

