/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.modules;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.loohp.holomobhealth.HoloMobHealth;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.modules.RangeModule;
import com.loohp.holomobhealth.nms.NMS;
import com.loohp.holomobhealth.protocol.EntityMetadata;
import com.loohp.holomobhealth.utils.ChatColorUtils;
import com.loohp.holomobhealth.utils.CitizensUtils;
import com.loohp.holomobhealth.utils.CustomNameUtils;
import com.loohp.holomobhealth.utils.EntityTypeUtils;
import com.loohp.holomobhealth.utils.MCVersion;
import com.loohp.holomobhealth.utils.MyPetUtils;
import com.loohp.holomobhealth.utils.MythicMobsUtils;
import com.loohp.holomobhealth.utils.ParsePlaceholders;
import com.loohp.holomobhealth.utils.ShopkeepersUtils;
import com.loohp.holomobhealth.utils.WorldGuardUtils;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class NameTagDisplay {
    public static void entityMetadataPacketListener() {
        HoloMobHealth.protocolManager.addPacketListener((PacketListener)new PacketAdapter(HoloMobHealth.plugin, ListenerPriority.MONITOR, new PacketType[]{PacketType.Play.Server.ENTITY_METADATA}){

            public void onPacketSending(PacketEvent event) {
                try {
                    if (!event.getPacketType().equals((Object)PacketType.Play.Server.ENTITY_METADATA)) {
                        return;
                    }
                    Player player = event.getPlayer();
                    if (!player.hasPermission("holomobhealth.use") || !HoloMobHealth.playersEnabled.contains(player)) {
                        return;
                    }
                    PacketContainer packet = event.getPacket();
                    World world = player.getWorld();
                    int entityId = (Integer)packet.getIntegers().read(0);
                    UUID entityUUID = NMS.getInstance().getEntityUUIDFromID(world, entityId);
                    if (entityUUID == null) {
                        return;
                    }
                    List<?> watcher = NameTagDisplay.getWatcher(player, entityUUID, world, packet);
                    if (watcher != null) {
                        boolean readOnly = event.isReadOnly();
                        event.setReadOnly(false);
                        event.setPacket(NMS.getInstance().createModifiedMetadataPacket(packet, watcher));
                        event.setReadOnly(readOnly);
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        });
        if (HoloMobHealth.version.isOlderThan(MCVersion.V1_19)) {
            HoloMobHealth.protocolManager.addPacketListener((PacketListener)new PacketAdapter(HoloMobHealth.plugin, ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.SPAWN_ENTITY_LIVING}){

                public void onPacketSending(PacketEvent event) {
                    try {
                        if (!event.getPacketType().equals((Object)PacketType.Play.Server.SPAWN_ENTITY_LIVING)) {
                            return;
                        }
                        PacketContainer packet = event.getPacket();
                        Player player = event.getPlayer();
                        World world = player.getWorld();
                        int entityId = (Integer)packet.getIntegers().read(0);
                        UUID entityUUID = NMS.getInstance().getEntityUUIDFromID(world, entityId);
                        if (entityUUID == null) {
                            return;
                        }
                        Entity entity = NMS.getInstance().getEntityFromUUID(entityUUID);
                        if (entity == null) {
                            return;
                        }
                        Bukkit.getScheduler().runTaskLater(HoloMobHealth.plugin, () -> EntityMetadata.updateEntity(player, entity), 5L);
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
            });
        }
        HoloMobHealth.protocolManager.addPacketListener((PacketListener)new PacketAdapter(HoloMobHealth.plugin, ListenerPriority.HIGHEST, new PacketType[]{PacketType.Play.Server.SPAWN_ENTITY}){

            public void onPacketSending(PacketEvent event) {
                try {
                    if (!event.getPacketType().equals((Object)PacketType.Play.Server.SPAWN_ENTITY)) {
                        return;
                    }
                    PacketContainer packet = event.getPacket();
                    Player player = event.getPlayer();
                    World world = player.getWorld();
                    int entityId = (Integer)packet.getIntegers().read(0);
                    UUID entityUUID = NMS.getInstance().getEntityUUIDFromID(world, entityId);
                    if (entityUUID == null) {
                        return;
                    }
                    Entity entity = NMS.getInstance().getEntityFromUUID(entityUUID);
                    if (entity == null) {
                        return;
                    }
                    Bukkit.getScheduler().runTaskLater(HoloMobHealth.plugin, () -> EntityMetadata.updateEntity(player, entity), 5L);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        });
    }

    public static List<?> getWatcher(Player player, UUID entityUUID, World world, PacketContainer packet) {
        Entity entity = NMS.getInstance().getEntityFromUUID(entityUUID);
        if (entity == null || !EntityTypeUtils.getMobsTypesSet().contains(EntityTypeUtils.getEntityType(entity))) {
            return null;
        }
        if (HoloMobHealth.disabledMobTypes.contains(EntityTypeUtils.getEntityType(entity))) {
            return null;
        }
        String customName = CustomNameUtils.getMobCustomName(entity);
        if (HoloMobHealth.rangeEnabled && !RangeModule.isEntityInRangeOfPlayer(player, entity)) {
            return null;
        }
        boolean useIdle = false;
        if (HoloMobHealth.useAlterHealth && !HoloMobHealth.altShowHealth.containsKey(entityUUID)) {
            if (!HoloMobHealth.idleUse) {
                return null;
            }
            useIdle = true;
        }
        if (!HoloMobHealth.disabledWorlds.contains(world.getName())) {
            if (HoloMobHealth.worldGuardHook && !WorldGuardUtils.checkStateFlag(entity.getLocation(), player, WorldGuardUtils.getHealthDisplayFlag())) {
                return null;
            }
            if (!HoloMobHealth.showCitizens && HoloMobHealth.citizensHook && CitizensUtils.isNPC(entity)) {
                return null;
            }
            if (!HoloMobHealth.showMythicMobs && HoloMobHealth.mythicHook && MythicMobsUtils.isMythicMob(entity)) {
                return null;
            }
            if (!HoloMobHealth.showShopkeepers && HoloMobHealth.shopkeepersHook && ShopkeepersUtils.isShopkeeper(entity)) {
                return null;
            }
            if (!HoloMobHealth.showMyPet && HoloMobHealth.myPetHook && MyPetUtils.isMyPet(entity)) {
                return null;
            }
            if (customName != null) {
                for (String each : HoloMobHealth.disabledMobNamesAbsolute) {
                    if (!customName.equals(ChatColorUtils.translateAlternateColorCodes('&', each))) continue;
                    return null;
                }
                for (String each : HoloMobHealth.disabledMobNamesContains) {
                    if (!ChatColorUtils.stripColor(customName.toLowerCase()).contains(ChatColorUtils.stripColor(ChatColorUtils.translateAlternateColorCodes('&', each).toLowerCase()))) continue;
                    return null;
                }
            }
            if (!HoloMobHealth.applyToNamed && customName != null) {
                return null;
            }
            List<?> watcher = NMS.getInstance().readDataWatchersFromMetadataPacket(packet);
            Component component = ParsePlaceholders.parse(player, (LivingEntity)entity, useIdle ? HoloMobHealth.idleDisplayText.get(0) : HoloMobHealth.displayText.get(0));
            boolean visible = HoloMobHealth.alwaysShow;
            NMS.getInstance().modifyDataWatchers(watcher, component, visible);
            return watcher;
        }
        return null;
    }
}

