/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.utils;

import com.loohp.holomobhealth.holders.ValuePairs;
import com.loohp.holomobhealth.libs.net.kyori.adventure.key.Key;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.Component;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.TextComponent;
import com.loohp.holomobhealth.libs.net.kyori.adventure.text.format.Style;
import com.loohp.holomobhealth.utils.ComponentCompacting;
import com.loohp.holomobhealth.utils.ComponentFlattening;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComponentFont {
    public static final Pattern FONT_TAG_PATTERN = Pattern.compile("(?i)(?:(?<!\\\\)(\\\\)\\\\|(?<!\\\\))\\[font=([a-z:0-9]*)\\]");
    public static final Pattern FONT_TAG_ESCAPE = Pattern.compile("(?i)\\\\(\\[font=[a-z:0-9]*\\])");

    public static Component parseFont(Component component) {
        component = ComponentFlattening.flatten(component);
        ArrayList<Component> children = new ArrayList<Component>();
        Key currentFont = null;
        for (Component child : component.children()) {
            if (child instanceof TextComponent) {
                TextComponent text = (TextComponent)child;
                Style style = text.style();
                if (style.font() == null) {
                    style = style.font(currentFont);
                }
                ValuePairs<Component, Key> result = ComponentFont.parseTags(text.content(), style);
                Component parsed = result.getFirst();
                List<Component> sections = ComponentFlattening.flatten(parsed).children();
                children.addAll(sections);
                currentFont = result.getSecond();
                continue;
            }
            if (child.font() == null) {
                children.add(child.font(currentFont));
                continue;
            }
            children.add(child);
        }
        return ComponentCompacting.optimize(component.children(children));
    }

    private static ValuePairs<Component, Key> parseTags(String content, Style style) {
        Component component = Component.empty();
        Key lastTagKey = null;
        Matcher matcher = FONT_TAG_PATTERN.matcher(content);
        int start = 0;
        while (matcher.find()) {
            String escape = matcher.group(1);
            String font = matcher.group(2);
            lastTagKey = font.isEmpty() ? null : Key.key(font);
            int end = matcher.start();
            String section = content.substring(start, end);
            if (escape != null) {
                section = section + escape;
            }
            component = component.append(Component.text(section).style(style));
            style = style.font(lastTagKey);
            start = matcher.end();
        }
        String section = content.substring(start);
        component = component.append(Component.text(section).style(style));
        component = ComponentFlattening.flatten(ComponentCompacting.optimize(component));
        ArrayList<Component> children = new ArrayList<Component>(component.children());
        for (int i = 0; i < children.size(); ++i) {
            Component child = (Component)children.get(i);
            if (!(child instanceof TextComponent)) continue;
            TextComponent textComponent = (TextComponent)child;
            matcher = FONT_TAG_ESCAPE.matcher(textComponent.content());
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String escaped = matcher.group(1);
                matcher.appendReplacement(sb, escaped);
            }
            matcher.appendTail(sb);
            textComponent = textComponent.content(sb.toString());
            children.set(i, textComponent);
        }
        return new ValuePairs<Component, Key>(ComponentCompacting.optimize(component.children(children)), lastTagKey);
    }
}

