/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.utils;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;

public enum MCVersion {
    V1_21_9("1.21.9", "1_21_R6", 35),
    V1_21_8("1.21.8", "1_21_R5", 34),
    V1_21_7("1.21.7", "1_21_R5", 33),
    V1_21_6("1.21.6", "1_21_R5", 32),
    V1_21_5("1.21.5", "1_21_R4", 31),
    V1_21_4("1.21.4", "1_21_R3", 30),
    V1_21_3("1.21.3", "1_21_R2", 29),
    V1_21_2("1.21.2", "1_21_R2", 28),
    V1_21_1("1.21.1", "1_21_R1", 27),
    V1_21("1.21", "1_21_R1", 26),
    V1_20_6("1.20.6", "1_20_R4", 25),
    V1_20_5("1.20.5", "1_20_R4", 24),
    V1_20_3("1.20.3", "1_20_R3", 23),
    V1_20_2("1.20.2", "1_20_R2", 22),
    V1_20("1.20", "1_20_R1", 21),
    V1_19_4("1.19.4", "1_19_R3", 20),
    V1_19_3("1.19.3", "1_19_R2", 19),
    V1_19("1.19", "1_19_R1", 18),
    V1_18_2("1.18.2", "1_18_R2", 17),
    V1_18("1.18", "1_18_R1", 16),
    V1_17("1.17", "1_17_R1", 15),
    V1_16_4("1.16.4", "1_16_R3", 14),
    V1_16_2("1.16.2", "1_16_R2", 13),
    V1_16("1.16", "1_16_R1", 12),
    V1_15("1.15", "1_15_R1", 11),
    V1_14("1.14", "1_14_R1", 10),
    V1_13_1("1.13.1", "1_13_R2", 9),
    V1_13("1.13", "1_13_R1", 8),
    V1_12("1.12", "1_12_R1", 7),
    V1_11("1.11", "1_11_R1", 6),
    V1_10("1.10", "1_10_R1", 5),
    V1_9_4("1.9.4", "1_9_R2", 4),
    V1_9("1.9", "1_9_R1", 3),
    V1_8_4("1.8.4", "1_8_R3", 2),
    V1_8_3("1.8.3", "1_8_R2", 1),
    V1_8("1.8", "1_8_R1", 0),
    UNSUPPORTED("Unsupported", null, -1);

    public static final MCVersion MINIMUM_SUPPORTED_VERSION;
    private static final MCVersion[] SUPPORTED_VALUES;
    private final String name;
    private final String packageName;
    private final int shortNum;

    public static MCVersion resolve() {
        MCVersion version = MCVersion.fromVersion(Bukkit.getVersion());
        if (version.isSupported()) {
            return version;
        }
        return MCVersion.fromPackageName(Bukkit.getServer().getClass().getPackage().getName());
    }

    public static MCVersion fromVersion(String bukkitVersion) {
        Pattern versionPattern = Pattern.compile("(?i)\\(MC:? ([0-9]+\\.[0-9]+(?:\\.[0-9]+)?)\\)");
        Matcher matcher = versionPattern.matcher(bukkitVersion);
        if (matcher.find()) {
            String minecraftVersion = matcher.group(1);
            for (MCVersion version : SUPPORTED_VALUES) {
                if (!minecraftVersion.equals(version.getMinecraftVersion())) continue;
                return version;
            }
        }
        return UNSUPPORTED;
    }

    public static MCVersion fromPackageName(String packageName) {
        for (MCVersion version : SUPPORTED_VALUES) {
            if (!packageName.contains(version.getPackageName())) continue;
            return version;
        }
        return UNSUPPORTED;
    }

    public static MCVersion fromNumber(int number) {
        for (MCVersion version : SUPPORTED_VALUES) {
            if (version.shortNum != number) continue;
            return version;
        }
        return UNSUPPORTED;
    }

    private MCVersion(String name, String packageName, int shortNum) {
        this.name = name;
        this.packageName = packageName;
        this.shortNum = shortNum;
    }

    public String toString() {
        return this.name;
    }

    public String getMinecraftVersion() {
        return this.name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getNumber() {
        return this.shortNum;
    }

    public int compareWith(MCVersion version) {
        return this.shortNum - version.shortNum;
    }

    public boolean isOlderThan(MCVersion version) {
        return this.compareWith(version) < 0;
    }

    public boolean isOlderOrEqualTo(MCVersion version) {
        return this.compareWith(version) <= 0;
    }

    public boolean isNewerThan(MCVersion version) {
        return this.compareWith(version) > 0;
    }

    public boolean isNewerOrEqualTo(MCVersion version) {
        return this.compareWith(version) >= 0;
    }

    public boolean isBetweenInclusively(MCVersion v1, MCVersion v2) {
        int difference = v1.compareWith(v2);
        if (difference == 0) {
            return this.equals((Object)v1);
        }
        if (difference < 0) {
            return this.isNewerOrEqualTo(v1) && this.isOlderOrEqualTo(v2);
        }
        return this.isNewerOrEqualTo(v2) && this.isOlderOrEqualTo(v1);
    }

    public boolean isLegacy() {
        return this.isOlderOrEqualTo(V1_12);
    }

    public boolean isOld() {
        return this.isOlderOrEqualTo(V1_8_4);
    }

    public boolean isSupported() {
        return this.shortNum >= MCVersion.MINIMUM_SUPPORTED_VERSION.shortNum;
    }

    public boolean isLegacyRGB() {
        return this.isOlderThan(V1_16);
    }

    static {
        MINIMUM_SUPPORTED_VERSION = V1_8;
        SUPPORTED_VALUES = (MCVersion[])Arrays.stream(MCVersion.values()).filter(v -> v.isSupported()).toArray(MCVersion[]::new);
    }
}

