/*
 * Decompiled with CFR 0.152.
 */
package com.loohp.holomobhealth.utils;

import com.comphenix.protocol.events.PacketContainer;
import com.loohp.holomobhealth.HoloMobHealth;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PacketSender {
    private static void schedule(Runnable runnable) {
        if (HoloMobHealth.sendPacketsOnMainThread && !Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask(HoloMobHealth.plugin, runnable);
        } else {
            runnable.run();
        }
    }

    public static void sendServerPacket(Player receiver, PacketContainer packet) {
        PacketSender.schedule(() -> {
            if (receiver.isOnline()) {
                HoloMobHealth.protocolManager.sendServerPacket(receiver, packet);
            }
        });
    }

    public static void sendServerPacket(Collection<? extends Player> receivers, PacketContainer packet) {
        PacketSender.schedule(() -> {
            for (Player receiver : receivers) {
                if (!receiver.isOnline()) continue;
                HoloMobHealth.protocolManager.sendServerPacket(receiver, packet);
            }
        });
    }

    public static void sendServerPackets(Player receiver, PacketContainer ... packets) {
        PacketSender.schedule(() -> {
            if (receiver.isOnline()) {
                for (PacketContainer packet : packets) {
                    HoloMobHealth.protocolManager.sendServerPacket(receiver, packet);
                }
            }
        });
    }

    public static void sendServerPackets(Player receiver, Collection<? extends PacketContainer> packets) {
        PacketSender.schedule(() -> {
            if (receiver.isOnline()) {
                for (PacketContainer packet : packets) {
                    HoloMobHealth.protocolManager.sendServerPacket(receiver, packet);
                }
            }
        });
    }

    public static void sendServerPackets(Collection<? extends Player> receivers, PacketContainer ... packets) {
        PacketSender.schedule(() -> {
            for (Player receiver : receivers) {
                if (!receiver.isOnline()) continue;
                for (PacketContainer packet : packets) {
                    HoloMobHealth.protocolManager.sendServerPacket(receiver, packet);
                }
            }
        });
    }

    public static void sendServerPackets(Collection<? extends Player> receivers, Collection<? extends PacketContainer> packets) {
        PacketSender.schedule(() -> {
            for (Player receiver : receivers) {
                if (!receiver.isOnline()) continue;
                for (PacketContainer packet : packets) {
                    HoloMobHealth.protocolManager.sendServerPacket(receiver, packet);
                }
            }
        });
    }

    public static void sendServerPacket(Player receiver, PacketContainer packet, boolean filters) {
        PacketSender.schedule(() -> {
            if (receiver.isOnline()) {
                HoloMobHealth.protocolManager.sendServerPacket(receiver, packet, filters);
            }
        });
    }
}

